/*
 * Decompiled with CFR 0.152.
 */
package org.alice.apis.moveandturn.gallery;

import edu.cmu.cs.dennisc.alice.annotations.ClassTemplate;
import edu.cmu.cs.dennisc.alice.annotations.PropertyGetterTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.codec.CodecUtilities;
import edu.cmu.cs.dennisc.codec.ReferenceableBinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import java.io.File;
import org.alice.apis.moveandturn.PolygonalModel;
import org.alice.apis.moveandturn.gallery.GalleryRootUtilities;

@ClassTemplate(isFollowToSuperClassDesired=true, isConsumptionBySubClassDesired=true)
public abstract class GalleryModel
extends PolygonalModel {
    public static final GetterSetterProperty<String> MODELED_BY_CREDIT_PROPERTY = new GetterSetterProperty(GalleryModel.class, "ModeledByCredit");
    public static final GetterSetterProperty<String> PAINTED_BY_CREDIT_PROPERTY = new GetterSetterProperty(GalleryModel.class, "PaintedByCredit");
    public static final GetterSetterProperty<String> PROGRAMMED_BY_CREDIT_PROPERTY = new GetterSetterProperty(GalleryModel.class, "ProgrammedByCredit");
    private String m_modeledByCredit = null;
    private String m_paintedByCredit = null;
    private String m_programmedByCredit = null;
    private static File s_galleryRootDirectory = GalleryRootUtilities.calculateGalleryRootDirectory(GalleryModel.class, "/Alice3Beta/gallery", "gallery", "assets", "org.alice.apis.moveandturn.gallery", "Alice Move & Turn Gallery", "Alice");
    private static final String CHILD_NAME = "assets";
    private static final String GRANDCHILD_NAME = "org.alice.apis.moveandturn.gallery";

    public static File getGalleryRootDirectory() {
        return s_galleryRootDirectory;
    }

    protected GalleryModel() {
    }

    public GalleryModel(String path) {
        File directory = new File(new File(s_galleryRootDirectory, CHILD_NAME), GRANDCHILD_NAME);
        File file = new File(directory, path + ".zip");
        assert (file.exists()) : path;
        CodecUtilities.decodeZippedReferenceableBinary((ReferenceableBinaryEncodableAndDecodable)this, (String)file.getAbsolutePath(), (String)"element.bin");
        this.realizeIfNecessary();
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public String getModeledByCredit() {
        return this.m_modeledByCredit;
    }

    public void setModeledByCredit(String modeledByCredit) {
        this.m_modeledByCredit = modeledByCredit;
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public String getPaintedByCredit() {
        return this.m_paintedByCredit;
    }

    public void setPaintedByCredit(String paintedByCredit) {
        this.m_paintedByCredit = paintedByCredit;
    }

    @PropertyGetterTemplate(visibility=Visibility.TUCKED_AWAY)
    public String getProgrammedByCredit() {
        return this.m_programmedByCredit;
    }

    public void setProgrammedByCredit(String programmedByCredit) {
        this.m_programmedByCredit = programmedByCredit;
    }
}

