/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import alice.kareltherobot.InfiniteBeepers;
import alice.kareltherobot.KarelWorld;
import alice.kareltherobot.KarelWorldItem;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.alice.apis.moveandturn.Color;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.Orientation;
import org.alice.apis.moveandturn.PointOfView;
import org.alice.apis.moveandturn.Position;
import org.alice.apis.moveandturn.Quaternion;
import org.alice.apis.moveandturn.event.MouseButtonEvent;
import org.alice.apis.moveandturn.event.MouseButtonListener;
import org.alice.apis.moveandturn.gallery.shapes.Cone;

public class Beeper
extends Cone
implements KarelWorldItem {
    private int street;
    private int avenue;

    public Beeper(int street, int avenue) {
        this.street = street;
        this.avenue = avenue;
        this.setColor(Color.ORANGE);
        this.setProgrammedByCredit("Joe Bergin");
        this.setWidth(0.4);
        this.setLocalPointOfView(new PointOfView((Orientation)new Quaternion((Number)0, (Number)0, (Number)0, (Number)1), new Position((Number)street, (Number)0.3, (Number)avenue)));
        this.addMouseButtonListener(new MouseButtonListener(){

            public void mouseButtonClicked(MouseButtonEvent arg0) {
                KarelWorld scene = Beeper.this.getWorld();
                if (scene == null || !scene.permissionToAct()) {
                    return;
                }
                int beepersHere = Beeper.this.howMany();
                String what = "There " + (beepersHere == 1 ? "is " : "are ") + (beepersHere == -1 ? "infinitely many" : Integer.valueOf(Beeper.this.howMany())) + " beeper" + (beepersHere == 1 ? "" : "s") + " here.";
                Beeper.this.say(what);
                System.out.println(what);
            }
        });
    }

    public KarelWorld getWorld() {
        try {
            return (KarelWorld)super.getScene();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int howMany() {
        int result = 0;
        for (Composite match : this.getScene().findAllMatches(Beeper.class)) {
            Beeper beep = (Beeper)match;
            if (match instanceof InfiniteBeepers && beep.street() == this.street && beep.avenue() == this.avenue) {
                return -1;
            }
            if (beep.street() != this.street || beep.avenue() != this.avenue) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int street() {
        return this.street;
    }

    @Override
    public int avenue() {
        return this.avenue;
    }

    protected void draw(Graphics2D g2) {
        double RADIUS = 0.2;
        g2.setStroke(new BasicStroke(0.05f));
        g2.draw(new Ellipse2D.Double((double)this.street - 0.2, (double)this.avenue - 0.2, 0.4, 0.4));
    }
}

