/*
 * Decompiled with CFR 0.152.
 */
package alice.kareltherobot;

import alice.kareltherobot.Beeper;
import alice.kareltherobot.InfiniteBeepers;
import alice.kareltherobot.KarelWorld;
import alice.kareltherobot.KarelWorldItem;
import alice.kareltherobot.Wall;
import com.jbergin.util.QuaternionCalculator;
import java.awt.Color;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.alice.apis.moveandturn.Composite;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.Orientation;
import org.alice.apis.moveandturn.PointOfView;
import org.alice.apis.moveandturn.Position;
import org.alice.apis.moveandturn.Program;
import org.alice.apis.moveandturn.SymmetricPerspectiveCamera;
import org.alice.apis.moveandturn.Transformable;
import org.alice.apis.moveandturn.TurnDirection;
import org.alice.apis.moveandturn.event.KeyEvent;
import org.alice.apis.moveandturn.event.KeyListener;
import org.alice.apis.moveandturn.event.MouseButtonEvent;
import org.alice.apis.moveandturn.event.MouseButtonListener;
import org.alice.apis.moveandturn.gallery.shapes.Square;

public class WorldBuilder
extends JFrame {
    private int lastStreetClick = 0;
    private int lastAvenueClick = 0;
    private MouseTarget lastMouseTarget = null;
    private boolean validClick = false;
    private Color bgcolor = new Color(251, 244, 239);
    private boolean tracing = false;
    private final State nullState;
    private State currentState = this.nullState = new NullState();
    private final State beeperState = new BeeperState();
    private final State removeState = new RemoveState();
    private final State infiniteBeeperState = new InfiniteBeeperState();
    private final State eastWestWallState = new EastWestWallState();
    private final State northSouthWallState = new NorthSouthWallState();
    BuilderWorld world;
    private static final long serialVersionUID = 1L;
    private JButton horizontalWall = new JButton("East-West Wall");
    private JButton verticalWall = new JButton("North-South Wall");
    private JButton beeper = new JButton("Beeper");
    private JButton infiniteBeeper = new JButton("Infinite Beepers");
    private JButton removing = new JButton("Remove Items");
    private JButton selectedButton = null;
    private WindowAdapter closer = null;
    private JButton save = new JButton("Save");
    private JButton open = new JButton("Open");
    private String filename = "untitled.kwld";
    private String directory = "";
    private boolean isDirty = false;
    private FileDialog openDialog = new FileDialog((Frame)this, null, 0);
    private FileDialog saveDialog = new FileDialog((Frame)this, null, 1);
    private Color selectedColor = new Color(192, 255, 192);
    private JLabel statusBar = new JLabel("");
    private JLabel fileBar = new JLabel(this.filename);
    private JButton clearAll = new JButton("Clear World");
    private JButton twoD = new JButton("2D World");
    private ItemDropper itemDropper = new ItemDropper();
    private Font displayFont = new Font("Dialog", 0, 14);
    private BeeperScaler beeperScaler = new BeeperScaler(false);
    private BeeperScaler infiniteBeeperScaler = new BeeperScaler(true);
    private HorizontalWallScaler horizontalWallScaler = new HorizontalWallScaler();
    private VerticalWallScaler verticalWallScaler = new VerticalWallScaler();
    static WorldBuilder worldBuilder = null;
    static int worldSize = 20;

    public void setTracing(boolean trace) {
        this.tracing = trace;
    }

    BuilderWorld getWorld() {
        return this.world;
    }

    void cleanUp() {
        if (this.isDirty) {
            this.saveFile();
        }
    }

    public WorldBuilder(int numberOfStreets) {
        super("World Builder");
        this.setSize(120, 160);
        this.setLocation(700, 30);
        Container content = this.getContentPane();
        this.closer = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorldBuilder.this.cleanUp();
                System.exit(0);
            }
        };
        this.addWindowListener(this.closer);
        JPanel toolPanel = new JPanel(new GridLayout(2, 1, 0, 20));
        content.add("Center", toolPanel);
        this.setBackground(this.bgcolor);
        JPanel buttonPanel = new JPanel(new GridLayout(8, 1, 0, 5));
        toolPanel.add("Center", buttonPanel);
        this.statusBar.setAlignmentX(0.5f);
        this.statusBar.setFont(this.displayFont);
        JLabel controller = new JLabel("  Karel World Builder");
        controller.setAlignmentX(0.5f);
        buttonPanel.add(controller);
        buttonPanel.add(this.statusBar);
        buttonPanel.add(this.horizontalWall);
        buttonPanel.add(this.verticalWall);
        buttonPanel.add(this.beeper);
        buttonPanel.add(this.infiniteBeeper);
        buttonPanel.add(this.removing);
        JPanel savePanel = new JPanel(new GridLayout(5, 1, 0, 5));
        toolPanel.add("South", savePanel);
        this.fileBar.setFont(this.displayFont);
        savePanel.add(this.save);
        savePanel.add(this.open);
        savePanel.add(this.fileBar);
        savePanel.add(this.clearAll);
        savePanel.add(this.twoD);
        this.horizontalWall.addActionListener(new HorizontalListener());
        this.verticalWall.addActionListener(new VerticalListener());
        this.beeper.addActionListener(new BeeperListener());
        this.infiniteBeeper.addActionListener(new InfiniteBeeperListener());
        this.removing.addActionListener(new RemoveListener());
        this.save.addActionListener(new SaveListener());
        this.open.addActionListener(new OpenListener());
        this.clearAll.addActionListener(new ClearListener());
        this.twoD.addActionListener(new TwoDListener());
        this.pack();
        this.setVisible(true);
        this.world = new BuilderWorld(numberOfStreets);
        this.world.setTheStage();
        KeyAdapter listen = new KeyAdapter(){

            @Override
            public void keyReleased(java.awt.event.KeyEvent e) {
                List list = WorldBuilder.this.world.getKeyListeners();
                KeyListener listen = (KeyListener)list.get(0);
                listen.keyPressed(new KeyEvent(e));
            }
        };
        this.beeper.addKeyListener(listen);
        this.horizontalWall.addKeyListener(listen);
        this.verticalWall.addKeyListener(listen);
    }

    private void saveFile() {
        this.saveDialog.setDirectory(this.directory);
        this.saveDialog.setFile(this.filename);
        this.saveDialog.setVisible(true);
        String result = this.saveDialog.getFile();
        if (result != null) {
            this.filename = result;
            this.fileBar.setText(result);
            this.directory = this.saveDialog.getDirectory();
            this.world.saveWorld(this.directory, this.filename);
            this.isDirty = false;
        }
    }

    public static void main(String[] args) {
        int size = 20;
        try {
            size = Integer.parseInt(args[0]);
            args[0] = "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        worldSize = size;
        worldBuilder = new WorldBuilder(size);
        try {
            if (args[1].equalsIgnoreCase("tracing")) {
                worldBuilder.setTracing(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (args[0].equalsIgnoreCase("tracing")) {
                worldBuilder.setTracing(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Program theProgram = new Program(){
            private static final long serialVersionUID = 1L;

            protected void initialize() {
                this.setScene(worldBuilder.getWorld());
            }

            protected void run() {
            }
        };
        args = new String[]{};
        theProgram.showInJFrame(args, true);
    }

    private class BeeperListener
    implements ActionListener {
        private BeeperListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton thisButton = (JButton)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((JButton)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.horizontalWall.setBackground(Color.lightGray);
                WorldBuilder.this.verticalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.world.removing = false;
                WorldBuilder.this.currentState = WorldBuilder.this.beeperState;
                WorldBuilder.this.currentState.setUp();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.currentState = WorldBuilder.this.nullState;
                WorldBuilder.this.itemDropper.setScaler(null);
            }
        }
    }

    private class BeeperScaler
    implements MouseScaler {
        private boolean dropInfinite = false;

        public BeeperScaler(boolean dropInfinite) {
            this.dropInfinite = dropInfinite;
        }

        @Override
        public void dropItem() {
            if (!WorldBuilder.this.validClick) {
                return;
            }
            int street = WorldBuilder.this.lastStreetClick;
            int avenue = WorldBuilder.this.lastAvenueClick;
            if (street < 1 || avenue < 1 || street > WorldBuilder.this.world.numberOfStreets() || avenue > WorldBuilder.this.world.numberOfAvenues()) {
                return;
            }
            if (!WorldBuilder.this.world.removing()) {
                if (!this.dropInfinite) {
                    WorldBuilder.this.world.placeBeepers(street, avenue, 1);
                    if (WorldBuilder.this.tracing) {
                        System.out.println("Placed a beeper at (" + street + ", " + avenue + ")");
                    }
                } else {
                    WorldBuilder.this.world.placeBeepers(street, avenue, -1, org.alice.apis.moveandturn.Color.BLACK);
                    if (WorldBuilder.this.tracing) {
                        System.out.println("Placed infinitely many beepers at (" + street + ", " + avenue + ")");
                    }
                }
                WorldBuilder.this.isDirty = true;
            }
        }
    }

    class BeeperState
    implements State {
        BeeperState() {
        }

        @Override
        public void setUp() {
            WorldBuilder.this.statusBar.setText("  Beeper");
            WorldBuilder.this.itemDropper.setScaler(WorldBuilder.this.beeperScaler);
        }

        @Override
        public void apply() {
            int howMany = WorldBuilder.this.world.getIntegerFromUser("How many beepers?");
            int i = 0;
            while (i < howMany) {
                WorldBuilder.this.itemDropper.dropItem();
                ++i;
            }
            if (howMany < 0) {
                howMany = 0;
            }
            String noun = howMany == 1 ? " beeper " : " beepers ";
            WorldBuilder.this.lastMouseTarget.say(String.valueOf(howMany) + noun + "placed.", 2);
        }
    }

    private class BuilderWorld
    extends KarelWorld {
        private int numberOfStreets = 15;
        private boolean removing = false;

        boolean removing() {
            return this.removing;
        }

        public BuilderWorld(int numberOfStreets) {
            this.numberOfStreets = numberOfStreets;
            this.setPermissionToAct(false);
            this.addMouseButtonListener(new MouseButtonListener(){

                public void mouseButtonClicked(MouseButtonEvent event) {
                    WorldBuilder.this.validClick = false;
                    Model item = event.getPartAtMouseLocation();
                    if (item instanceof MouseTarget) {
                        WorldBuilder.this.validClick = true;
                        MouseTarget target = (MouseTarget)item;
                        WorldBuilder.this.lastStreetClick = target.street();
                        WorldBuilder.this.lastAvenueClick = target.avenue();
                        WorldBuilder.this.lastMouseTarget = target;
                        WorldBuilder.this.currentState.apply();
                    } else if (item instanceof Beeper && BuilderWorld.this.removing) {
                        Beeper beep = (Beeper)item;
                        BuilderWorld.this.removeComponent((Transformable)item);
                        if (WorldBuilder.this.tracing) {
                            if (item instanceof InfiniteBeepers) {
                                System.out.println("Removed infinitely many beepers from (" + beep.street() + ", " + beep.avenue() + ")");
                            } else {
                                System.out.println("Removed a beeper from (" + beep.street() + ", " + beep.avenue() + ")");
                            }
                        }
                    } else if (item instanceof Beeper && WorldBuilder.this.itemDropper.scaler instanceof BeeperScaler || WorldBuilder.this.itemDropper.scaler instanceof WallScaler) {
                        KarelWorldItem beep = (KarelWorldItem)item;
                        WorldBuilder.this.validClick = true;
                        WorldBuilder.this.lastStreetClick = beep.street();
                        WorldBuilder.this.lastAvenueClick = beep.avenue();
                        WorldBuilder.this.currentState.apply();
                    } else if (item instanceof Wall && BuilderWorld.this.removing) {
                        BuilderWorld.this.removeComponent((Transformable)item);
                        if (WorldBuilder.this.tracing) {
                            Wall wall = (Wall)item;
                            String direction = wall.getDirection() == 1 ? "a North-South" : "an East-West";
                            System.out.println("Removed " + direction + " wall near (" + wall.street() + ", " + wall.avenue() + ")");
                        }
                    }
                }
            });
        }

        public void placeBeepers(int street, int avenue, int howMany, org.alice.apis.moveandturn.Color color) {
            if (howMany < 0) {
                InfiniteBeepers beep = new InfiniteBeepers(street, avenue);
                beep.setColor(color);
                this.addComponent((Transformable)beep);
            } else {
                int i = 0;
                while (i < howMany) {
                    Beeper beep = new Beeper(street, avenue);
                    beep.setColor(color);
                    this.addComponent((Transformable)beep);
                    ++i;
                }
            }
        }

        public int numberOfStreets() {
            return this.numberOfStreets;
        }

        public int numberOfAvenues() {
            return this.numberOfStreets;
        }

        @Override
        public void run() {
        }

        @Override
        public void setTheStage() {
            SymmetricPerspectiveCamera camera = this.getCamera();
            camera.turn(TurnDirection.BACKWARD, (Number)0.08333333333333333);
            camera.move(MoveDirection.UP, (Number)7);
            camera.move(MoveDirection.RIGHT, (Number)7);
            camera.turn(TurnDirection.LEFT, (Number)0.09583333333333334);
            camera.move(MoveDirection.FORWARD, (Number)10);
            camera.turn(TurnDirection.FORWARD, (Number)0.2361111111111111);
            int size = this.numberOfStreets;
            int i = 1;
            while (i <= size) {
                int j = 1;
                while (j <= size) {
                    MouseTarget target = new MouseTarget(i, j);
                    this.addComponent((Transformable)target);
                    ++j;
                }
                ++i;
            }
        }
    }

    private class ClearListener
    implements ActionListener {
        private ClearListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorldBuilder.this.world.reset();
            WorldBuilder.this.isDirty = true;
            WorldBuilder.this.repaint();
            if (WorldBuilder.this.tracing) {
                System.out.println("World cleared.");
            }
        }
    }

    class EastWestWallState
    implements State {
        EastWestWallState() {
        }

        @Override
        public void setUp() {
            WorldBuilder.this.statusBar.setText("  East-West Wall");
            WorldBuilder.this.itemDropper.setScaler(WorldBuilder.this.horizontalWallScaler);
        }

        @Override
        public void apply() {
            WorldBuilder.this.itemDropper.dropItem();
        }
    }

    private class HorizontalListener
    implements ActionListener {
        private HorizontalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton thisButton = (JButton)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((JButton)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.beeper.setBackground(Color.lightGray);
                WorldBuilder.this.verticalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.world.removing = false;
                WorldBuilder.this.currentState = WorldBuilder.this.eastWestWallState;
                WorldBuilder.this.currentState.setUp();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.currentState = WorldBuilder.this.nullState;
                WorldBuilder.this.itemDropper.setScaler(null);
            }
        }
    }

    private class HorizontalWallScaler
    implements WallScaler {
        private HorizontalWallScaler() {
        }

        @Override
        public void dropItem() {
            int street = WorldBuilder.this.lastStreetClick;
            int avenue = WorldBuilder.this.lastAvenueClick;
            if (street < 1 || avenue < 1 || street > WorldBuilder.this.world.numberOfStreets() - 1 || avenue > WorldBuilder.this.world.numberOfAvenues()) {
                return;
            }
            if (!WorldBuilder.this.world.removing()) {
                WorldBuilder.this.world.placeWallNorthOf(street, avenue);
                if (WorldBuilder.this.tracing) {
                    System.out.println("Placed an East-West wall north of (" + street + ", " + avenue + ")");
                }
                WorldBuilder.this.isDirty = true;
            }
        }
    }

    private class InfiniteBeeperListener
    implements ActionListener {
        private InfiniteBeeperListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton thisButton = (JButton)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((JButton)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.horizontalWall.setBackground(Color.lightGray);
                WorldBuilder.this.verticalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.world.removing = false;
                WorldBuilder.this.currentState = WorldBuilder.this.infiniteBeeperState;
                WorldBuilder.this.currentState.setUp();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.currentState = WorldBuilder.this.nullState;
                WorldBuilder.this.itemDropper.setScaler(null);
            }
        }
    }

    class InfiniteBeeperState
    implements State {
        InfiniteBeeperState() {
        }

        @Override
        public void setUp() {
            WorldBuilder.this.statusBar.setText("  Infinite Beepers");
            WorldBuilder.this.itemDropper.setScaler(WorldBuilder.this.infiniteBeeperScaler);
        }

        @Override
        public void apply() {
            WorldBuilder.this.itemDropper.dropItem();
            WorldBuilder.this.lastMouseTarget.say("Infinitely many beepers placed.", 2);
        }
    }

    private class ItemDropper
    extends MouseAdapter {
        private MouseScaler scaler = null;

        private ItemDropper() {
        }

        public void dropItem() {
            if (this.scaler != null) {
                this.scaler.dropItem();
                WorldBuilder.this.isDirty = true;
            }
        }

        public void setScaler(MouseScaler scaler) {
            this.scaler = scaler;
        }
    }

    static interface MouseScaler {
        public void dropItem();
    }

    private class MouseTarget
    extends Square {
        private final double size = 0.15;
        private int street;
        private int avenue;

        public MouseTarget(int street, int avenue) {
            this.street = street;
            this.avenue = avenue;
            this.setWidth(0.15);
            this.setColor(org.alice.apis.moveandturn.Color.BLUE);
            this.setLocalPointOfView(new PointOfView((Orientation)QuaternionCalculator.rotationAboutX(90.0), new Position((Number)street, (Number)0.05, (Number)avenue)));
        }

        public int street() {
            return this.street;
        }

        public int avenue() {
            return this.avenue;
        }
    }

    class NorthSouthWallState
    implements State {
        NorthSouthWallState() {
        }

        @Override
        public void setUp() {
            WorldBuilder.this.statusBar.setText("  North-South Wall");
            WorldBuilder.this.itemDropper.setScaler(WorldBuilder.this.verticalWallScaler);
        }

        @Override
        public void apply() {
            WorldBuilder.this.itemDropper.dropItem();
        }
    }

    class NullState
    implements State {
        NullState() {
        }

        @Override
        public void apply() {
        }

        @Override
        public void setUp() {
            WorldBuilder.this.statusBar.setText("");
            WorldBuilder.this.itemDropper.setScaler(null);
        }
    }

    private class OpenListener
    implements ActionListener {
        private OpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorldBuilder.this.openDialog.setDirectory(WorldBuilder.this.directory);
            WorldBuilder.this.openDialog.setFile(WorldBuilder.this.filename);
            WorldBuilder.this.openDialog.setVisible(true);
            String result = WorldBuilder.this.openDialog.getFile();
            if (result != null) {
                WorldBuilder.this.filename = result;
                WorldBuilder.this.fileBar.setText(result);
                WorldBuilder.this.directory = WorldBuilder.this.openDialog.getDirectory();
                WorldBuilder.this.world.readWorld(WorldBuilder.this.directory, WorldBuilder.this.filename);
                WorldBuilder.this.isDirty = true;
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton thisButton = (JButton)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((JButton)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.horizontalWall.setBackground(Color.lightGray);
                WorldBuilder.this.verticalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.world.removing = true;
                WorldBuilder.this.currentState = WorldBuilder.this.removeState;
                WorldBuilder.this.currentState.setUp();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.world.removing = false;
                WorldBuilder.this.itemDropper.setScaler(null);
            }
        }
    }

    class RemoveState
    implements State {
        RemoveState() {
        }

        @Override
        public void apply() {
            int street = WorldBuilder.this.lastStreetClick;
            int avenue = WorldBuilder.this.lastAvenueClick;
            for (Composite match : WorldBuilder.this.world.findAllMatches(Wall.class)) {
                Wall wall = (Wall)match;
                if (wall.street() != street || wall.avenue() != avenue) continue;
                WorldBuilder.this.world.removeComponent((Transformable)wall);
                if (!WorldBuilder.this.tracing) continue;
                String direction = wall.getDirection() == 1 ? "a North-South" : "an East-West";
                System.out.println("Removed " + direction + " wall near (" + wall.street() + ", " + wall.avenue() + ")");
            }
            for (Composite match : WorldBuilder.this.world.findAllMatches(Beeper.class)) {
                Beeper beeper = (Beeper)match;
                if (beeper.street() != street || beeper.avenue() != avenue) continue;
                WorldBuilder.this.world.removeComponent((Transformable)beeper);
                if (!WorldBuilder.this.tracing) continue;
                System.out.println("Removed a beeper from (" + beeper.street() + ", " + beeper.avenue() + ")");
            }
        }

        @Override
        public void setUp() {
            WorldBuilder.this.statusBar.setText("  Removing");
            WorldBuilder.this.itemDropper.setScaler(null);
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorldBuilder.this.saveFile();
            WorldBuilder.this.repaint();
        }
    }

    static interface State {
        public void setUp();

        public void apply();
    }

    private class TwoDListener
    implements ActionListener {
        private TwoDListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    ((TwoDListener)TwoDListener.this).WorldBuilder.this.world.show2DScene(1, 1, worldSize, worldSize);
                }
            };
            new Thread(runner).start();
        }
    }

    private class VerticalListener
    implements ActionListener {
        private VerticalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton thisButton = (JButton)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((JButton)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.beeper.setBackground(Color.lightGray);
                WorldBuilder.this.horizontalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.world.removing = false;
                WorldBuilder.this.currentState = WorldBuilder.this.northSouthWallState;
                WorldBuilder.this.currentState.setUp();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.currentState = WorldBuilder.this.nullState;
                WorldBuilder.this.itemDropper.setScaler(null);
            }
        }
    }

    private class VerticalWallScaler
    implements WallScaler {
        private VerticalWallScaler() {
        }

        @Override
        public void dropItem() {
            int street = WorldBuilder.this.lastStreetClick;
            int avenue = WorldBuilder.this.lastAvenueClick;
            if (street < 1 || avenue < 1 || street > WorldBuilder.this.world.numberOfStreets() || avenue > WorldBuilder.this.world.numberOfAvenues() - 1) {
                return;
            }
            if (!WorldBuilder.this.world.removing()) {
                if (WorldBuilder.this.tracing) {
                    System.out.println("Placed a North-South wall east of (" + street + ", " + avenue + ")");
                }
                WorldBuilder.this.world.placeWallEastOf(street, avenue);
                WorldBuilder.this.isDirty = true;
            }
        }
    }

    static interface WallScaler
    extends MouseScaler {
    }
}

