/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.PackageReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.ReflectionProxy;
import edu.cmu.cs.dennisc.lang.ClassUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassReflectionProxy
extends ReflectionProxy<Class<?>> {
    private String name;

    public static ClassReflectionProxy[] create(Class<?>[] clses) {
        ClassReflectionProxy[] rv = new ClassReflectionProxy[clses.length];
        for (int i = 0; i < clses.length; ++i) {
            rv[i] = new ClassReflectionProxy(clses[i]);
        }
        return rv;
    }

    public static Class<?>[] getReifications(ClassReflectionProxy[] classReflectionProxies) {
        Class[] rv = new Class[classReflectionProxies.length];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = (Class)classReflectionProxies[i].getReification();
        }
        return rv;
    }

    public ClassReflectionProxy(String name) {
        this.name = name;
    }

    public ClassReflectionProxy(Class<?> cls) {
        super(cls);
        this.name = cls.getName();
    }

    @Override
    protected int hashCodeNonReifiable() {
        return this.name.hashCode();
    }

    @Override
    protected boolean equalsInstanceOfSameClassButNonReifiable(ReflectionProxy<?> o) {
        ClassReflectionProxy other = (ClassReflectionProxy)o;
        return this.name != null ? this.name.equals(other.name) : other.name == null;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        Class cls = (Class)this.getReification();
        if (cls != null) {
            return cls.getSimpleName();
        }
        String[] simpleNames = ClassUtilities.getSimpleClassNames(this.name);
        return simpleNames[simpleNames.length - 1];
    }

    public boolean isArray() {
        Class cls = (Class)this.getReification();
        if (cls != null) {
            return cls.isArray();
        }
        return ClassUtilities.getArrayDimensionCount(this.name) > 0;
    }

    public ClassReflectionProxy getComponentClassReflectionProxy() {
        Class cls = (Class)this.getReification();
        if (cls != null) {
            Class<?> componentCls = cls.getComponentType();
            if (componentCls != null) {
                return new ClassReflectionProxy(componentCls);
            }
            return null;
        }
        if (this.name.charAt(0) == '[') {
            return new ClassReflectionProxy(this.name.substring(1));
        }
        return null;
    }

    public ClassReflectionProxy getDeclaringClassReflectionProxy() {
        Class cls = (Class)this.getReification();
        if (cls != null) {
            Class<?> declaringCls = cls.getDeclaringClass();
            if (declaringCls != null) {
                return new ClassReflectionProxy(declaringCls);
            }
            return null;
        }
        int index = this.name.lastIndexOf("$");
        if (index != -1) {
            return new ClassReflectionProxy(this.name.substring(0, index));
        }
        return null;
    }

    public PackageReflectionProxy getPackageReflectionProxy() {
        Class cls = (Class)this.getReification();
        if (cls != null) {
            Package pckg = cls.getPackage();
            if (pckg != null) {
                return new PackageReflectionProxy(pckg);
            }
            return null;
        }
        String packageName = ClassUtilities.getPackageName(this.name);
        if (packageName != null) {
            return new PackageReflectionProxy(packageName);
        }
        return null;
    }

    @Override
    protected Class<?> reify() {
        try {
            return ClassUtilities.forName(this.name);
        }
        catch (ClassNotFoundException cnfe) {
            PrintUtilities.println("WARNING: could not find class", this.name);
            return null;
        }
    }
}

