/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.AbstractDeclaration;
import edu.cmu.cs.dennisc.alice.ast.AnonymousConstructor;
import edu.cmu.cs.dennisc.alice.ast.AnonymousInnerTypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.ArrayTypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.ClassReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.ConstructorDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.ConstructorReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithField;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithGetterAndSetter;
import edu.cmu.cs.dennisc.alice.ast.FieldReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.MethodDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.MethodReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.Node;
import edu.cmu.cs.dennisc.alice.ast.NullLiteral;
import edu.cmu.cs.dennisc.alice.ast.ParameterDeclaredInJavaConstructor;
import edu.cmu.cs.dennisc.alice.ast.ParameterDeclaredInJavaMethod;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.map.MapToMap;
import edu.cmu.cs.dennisc.xml.XMLUtilities;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decoder {
    private static MapToMap<Class<?>, String, Class<?>> mapToMap = new MapToMap();
    private String srcVersion;
    private String dstVersion;
    private boolean isUUIDDecodingDesired;

    public static void addMethodFilter(Class<?> prevCls, String name, Class<?> nextCls) {
        mapToMap.put(prevCls, name, nextCls);
    }

    private static Class<?> filterClsIfNecessary(Class<?> cls, String name) {
        Class<?> rv = mapToMap.get(cls, name);
        if (rv == null) {
            rv = cls;
        }
        return rv;
    }

    public Decoder(String srcVersion, String dstVersion, boolean isUUIDDecodingDesired) {
        this.srcVersion = srcVersion;
        this.dstVersion = dstVersion;
        this.isUUIDDecodingDesired = isUUIDDecodingDesired;
    }

    private String getClassName(Element xmlElement) {
        String rv = xmlElement.getAttribute("type");
        if (!this.srcVersion.contains("alpha") || this.dstVersion.contains("beta")) {
            // empty if block
        }
        return rv;
    }

    private ClassReflectionProxy getJavaClassInfo(Element xmlElement) {
        return new ClassReflectionProxy(this.getClassName(xmlElement));
    }

    private Class<?> getCls(Element xmlElement) {
        return ReflectionUtilities.getClassForName(this.getClassName(xmlElement));
    }

    private Object newInstance(Element xmlElement) {
        return ReflectionUtilities.newInstance(this.getClassName(xmlElement));
    }

    public Object decodeValue(Element xmlValue, Map<Integer, AbstractDeclaration> map) {
        Object rv;
        if (xmlValue.hasAttribute("isNull")) {
            rv = null;
        } else {
            String tagName = xmlValue.getTagName();
            if (tagName.equals("node")) {
                try {
                    rv = this.decode(xmlValue, map);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                    rv = new NullLiteral();
                }
            } else if (tagName.equals("collection")) {
                Collection collection = (Collection)this.newInstance(xmlValue);
                NodeList nodeList = xmlValue.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element xmlItem = (Element)nodeList.item(i);
                    collection.add(this.decodeValue(xmlItem, map));
                }
                rv = collection;
            } else if (tagName.equals("value")) {
                Class<?> cls = this.getCls(xmlValue);
                String textContent = xmlValue.getTextContent();
                if (cls.equals(String.class)) {
                    rv = textContent;
                } else {
                    try {
                        rv = ReflectionUtilities.valueOf(cls, textContent);
                    }
                    catch (RuntimeException re) {
                        if ("DIVIDE".equals(textContent)) {
                            rv = ReflectionUtilities.valueOf(cls, "REAL_DIVIDE");
                        }
                        if ("REMAINDER".equals(textContent)) {
                            rv = ReflectionUtilities.valueOf(cls, "REAL_REMAINDER");
                        }
                        throw re;
                    }
                }
            } else {
                throw new RuntimeException();
            }
        }
        return rv;
    }

    private ClassReflectionProxy decodeType(Element xmlElement, String nodeName) {
        Element xmlClass = XMLUtilities.getSingleChildElementByTagName(xmlElement, nodeName);
        String clsName = xmlClass.getAttribute("name");
        return new ClassReflectionProxy(clsName);
    }

    private ArrayTypeDeclaredInAlice decodeArrayTypeDeclaredInAlice(Element xmlElement, Map<Integer, AbstractDeclaration> map) {
        Element xmlLeafType = XMLUtilities.getSingleChildElementByTagName(xmlElement, "leafType");
        Element xmlDimensionCount = XMLUtilities.getSingleChildElementByTagName(xmlElement, "dimensionCount");
        Element xmlLeafTypeNode = XMLUtilities.getSingleChildElementByTagName(xmlLeafType, "node");
        TypeDeclaredInAlice leafType = (TypeDeclaredInAlice)this.decode(xmlLeafTypeNode, map);
        int dimensionCount = Integer.parseInt(xmlDimensionCount.getTextContent());
        return ArrayTypeDeclaredInAlice.get(leafType, dimensionCount);
    }

    private AnonymousConstructor decodeAnonymousConstructor(Element xmlElement, Map<Integer, AbstractDeclaration> map) {
        Element xmlLeafType = XMLUtilities.getSingleChildElementByTagName(xmlElement, "anonymousType");
        Element xmlLeafTypeNode = (Element)xmlLeafType.getChildNodes().item(0);
        AnonymousInnerTypeDeclaredInAlice anonymousType = (AnonymousInnerTypeDeclaredInAlice)this.decode(xmlLeafTypeNode, map);
        return AnonymousConstructor.get(anonymousType);
    }

    private ClassReflectionProxy decodeDeclaringClass(Element xmlElement) {
        return this.decodeType(xmlElement, "declaringClass");
    }

    private ClassReflectionProxy[] decodeParameters(Element xmlElement) {
        Element xmlParameters = XMLUtilities.getSingleChildElementByTagName(xmlElement, "parameters");
        List<Element> xmlTypes = XMLUtilities.getChildElementsByTagName(xmlParameters, "type");
        ClassReflectionProxy[] rv = new ClassReflectionProxy[xmlTypes.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = new ClassReflectionProxy(xmlTypes.get(i).getAttribute("name"));
        }
        return rv;
    }

    private FieldReflectionProxy decodeField(Element xmlParent, String nodeName) {
        Element xmlField = XMLUtilities.getSingleChildElementByTagName(xmlParent, nodeName);
        ClassReflectionProxy declaringCls = this.decodeDeclaringClass(xmlField);
        String name = xmlField.getAttribute("name");
        return new FieldReflectionProxy(declaringCls, name);
    }

    private ConstructorReflectionProxy decodeConstructor(Element xmlParent, String nodeName) {
        Element xmlConstructor = XMLUtilities.getSingleChildElementByTagName(xmlParent, nodeName);
        ClassReflectionProxy declaringCls = this.decodeDeclaringClass(xmlConstructor);
        ClassReflectionProxy[] parameterClses = this.decodeParameters(xmlConstructor);
        return new ConstructorReflectionProxy(declaringCls, parameterClses);
    }

    private MethodReflectionProxy decodeMethod(Element xmlParent, String nodeName) {
        Element xmlMethod = XMLUtilities.getSingleChildElementByTagName(xmlParent, nodeName);
        ClassReflectionProxy declaringCls = this.decodeDeclaringClass(xmlMethod);
        String name = xmlMethod.getAttribute("name");
        ClassReflectionProxy[] parameterClses = this.decodeParameters(xmlMethod);
        return new MethodReflectionProxy(declaringCls, name, parameterClses);
    }

    public Node decode(Element xmlElement, Map<Integer, AbstractDeclaration> map) {
        Node rv;
        if (xmlElement.hasAttribute("type")) {
            NodeList nodeList;
            String clsName = this.getClassName(xmlElement);
            if (clsName.equals(TypeDeclaredInJava.class.getName())) {
                rv = TypeDeclaredInJava.get(this.decodeType(xmlElement, "type"));
            } else if (clsName.equals(ArrayTypeDeclaredInAlice.class.getName())) {
                rv = this.decodeArrayTypeDeclaredInAlice(xmlElement, map);
            } else if (clsName.equals(ConstructorDeclaredInJava.class.getName())) {
                rv = ConstructorDeclaredInJava.get(this.decodeConstructor(xmlElement, "constructor"));
            } else if (clsName.equals(MethodDeclaredInJava.class.getName())) {
                rv = MethodDeclaredInJava.get(this.decodeMethod(xmlElement, "method"));
            } else if (clsName.equals(FieldDeclaredInJavaWithField.class.getName())) {
                rv = FieldDeclaredInJavaWithField.get(this.decodeField(xmlElement, "field"));
            } else if (clsName.equals(FieldDeclaredInJavaWithGetterAndSetter.class.getName())) {
                MethodReflectionProxy gttr = this.decodeMethod(xmlElement, "getter");
                MethodReflectionProxy sttr = this.decodeMethod(xmlElement, "setter");
                rv = FieldDeclaredInJavaWithGetterAndSetter.get(gttr, sttr);
            } else if (clsName.equals(AnonymousConstructor.class.getName())) {
                rv = this.decodeAnonymousConstructor(xmlElement, map);
            } else if (clsName.equals(ParameterDeclaredInJavaConstructor.class.getName())) {
                nodeList = xmlElement.getChildNodes();
                assert (nodeList.getLength() == 2);
                Element xmlConstructor = (Element)nodeList.item(0);
                ConstructorDeclaredInJava constructorDeclaredInJava = (ConstructorDeclaredInJava)this.decodeValue(xmlConstructor, map);
                Element xmlIndex = (Element)nodeList.item(1);
                int index = Integer.parseInt(xmlIndex.getTextContent());
                rv = constructorDeclaredInJava.getParameters().get(index);
            } else if (clsName.equals(ParameterDeclaredInJavaMethod.class.getName())) {
                nodeList = xmlElement.getChildNodes();
                assert (nodeList.getLength() == 2);
                Element xmlMethod = (Element)nodeList.item(0);
                MethodDeclaredInJava methodDeclaredInJava = (MethodDeclaredInJava)this.decodeValue(xmlMethod, map);
                Element xmlIndex = (Element)nodeList.item(1);
                int index = Integer.parseInt(xmlIndex.getTextContent());
                rv = methodDeclaredInJava.getParameters().get(index);
            } else {
                rv = (Node)this.newInstance(xmlElement);
                assert (rv != null);
            }
            if (rv instanceof AbstractDeclaration) {
                int key = Integer.parseInt(xmlElement.getAttribute("key"), 16);
                map.put(key, (AbstractDeclaration)rv);
            }
            rv.decodeNode(this, xmlElement, map);
            if (xmlElement.hasAttribute("uuid") && this.isUUIDDecodingDesired) {
                rv.setUUID(UUID.fromString(xmlElement.getAttribute("uuid")));
            }
        } else {
            int key = Integer.parseInt(xmlElement.getAttribute("key"), 16);
            rv = map.get(key);
            assert (rv != null);
        }
        return rv;
    }
}

