/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.ClassReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.MemberReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.ReflectionProxy;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldReflectionProxy
extends MemberReflectionProxy<Field> {
    private String name;

    public FieldReflectionProxy(ClassReflectionProxy declaringClassReflectionProxy, String name) {
        super(declaringClassReflectionProxy);
        this.name = name;
    }

    public FieldReflectionProxy(Field fld) {
        super(fld, fld.getDeclaringClass());
        this.name = fld.getName();
    }

    @Override
    protected int hashCodeNonReifiable() {
        int rv = super.hashCodeNonReifiable();
        rv = 37 * rv + this.name.hashCode();
        return rv;
    }

    @Override
    protected boolean equalsInstanceOfSameClassButNonReifiable(ReflectionProxy<?> o) {
        if (super.equalsInstanceOfSameClassButNonReifiable(o)) {
            FieldReflectionProxy other = (FieldReflectionProxy)o;
            return this.name != null ? this.name.equals(other.name) : other.name == null;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected Field reify() {
        Class cls = (Class)this.getDeclaringClassReflectionProxy().getReification();
        if (cls != null) {
            try {
                return cls.getField(this.name);
            }
            catch (NoSuchFieldException nsfe) {
                return null;
            }
        }
        return null;
    }
}

