/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

public class IdentifierUtilities {
    public static boolean isValidIdentifier(String name) {
        int N = name.length();
        if (name != null && N > 0) {
            char name0 = name.charAt(0);
            if (Character.isLetter(name0) || name0 == '_') {
                for (int i = 1; i < N; ++i) {
                    char c = name.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static String getConventionalIdentifierName(String name, boolean cap) {
        String rv = "";
        boolean isAlphaEncountered = false;
        int N = name.length();
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (Character.isDigit(c)) {
                    if (!isAlphaEncountered) {
                        rv = rv + "_";
                        rv = rv + c;
                        isAlphaEncountered = true;
                        continue;
                    }
                } else {
                    isAlphaEncountered = true;
                }
                if (cap) {
                    c = Character.toUpperCase(c);
                }
                rv = rv + c;
                cap = Character.isDigit(c);
                continue;
            }
            cap = true;
        }
        return rv;
    }

    public static String getConventionalInstanceName(String text) {
        return IdentifierUtilities.getConventionalIdentifierName(text, false);
    }

    public static String getConventionalClassName(String text) {
        return IdentifierUtilities.getConventionalIdentifierName(text, true);
    }
}

