/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.AbstractMethod;
import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.AnonymousInnerTypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.Argument;
import edu.cmu.cs.dennisc.alice.ast.ArgumentListProperty;
import edu.cmu.cs.dennisc.alice.ast.DeclarationProperty;
import edu.cmu.cs.dennisc.alice.ast.Expression;
import edu.cmu.cs.dennisc.alice.ast.ExpressionProperty;
import edu.cmu.cs.dennisc.alice.ast.Node;
import edu.cmu.cs.dennisc.alice.ast.NullLiteral;
import java.util.Locale;

public class MethodInvocation
extends Expression {
    public ExpressionProperty expression = new ExpressionProperty(this){

        public AbstractType getExpressionType() {
            return ((AbstractMethod)MethodInvocation.this.method.getValue()).getDeclaringType();
        }
    };
    public DeclarationProperty<AbstractMethod> method = new DeclarationProperty(this);
    public ArgumentListProperty arguments = new ArgumentListProperty(this);

    public MethodInvocation() {
    }

    public MethodInvocation(Expression expression, AbstractMethod method, Argument ... arguments) {
        AbstractType declaringType;
        AbstractType expressionType;
        if (expression instanceof NullLiteral || (expressionType = expression.getType()) == null || (declaringType = method.getDeclaringType()) != null) {
            // empty if block
        }
        this.expression.setValue(expression);
        this.method.setValue(method);
        this.arguments.add(arguments);
    }

    public AbstractType getType() {
        return ((AbstractMethod)this.method.getValue()).getReturnType();
    }

    public boolean isValid() {
        boolean rv = false;
        Expression e = (Expression)this.expression.getValue();
        AbstractMethod m = (AbstractMethod)this.method.getValue();
        if (e != null && m != null) {
            if (m.isStatic()) {
                rv = true;
            } else {
                AbstractType declaringType = m.getDeclaringType();
                AbstractType expressionType = e.getType();
                rv = expressionType instanceof AnonymousInnerTypeDeclaredInAlice ? true : (declaringType != null && expressionType != null ? declaringType.isAssignableFrom(expressionType) : false);
            }
        } else {
            rv = false;
        }
        return rv;
    }

    protected StringBuffer appendRepr(StringBuffer rv, Locale locale) {
        Node.safeAppendRepr(rv, (Node)this.method.getValue(), locale);
        return rv;
    }
}

