/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.DeclarationProperty;
import edu.cmu.cs.dennisc.alice.ast.Expression;
import edu.cmu.cs.dennisc.alice.ast.InfixExpression;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalInfixExpression
extends InfixExpression<Operator> {
    public DeclarationProperty<AbstractType> leftOperandType = new DeclarationProperty(this);
    public DeclarationProperty<AbstractType> rightOperandType = new DeclarationProperty(this);

    private static boolean isNumberComparisonDesired(Object leftOperand, Object rightOperand) {
        return leftOperand instanceof Number && rightOperand instanceof Number;
    }

    private static boolean isDoubleComparisonDesired(Object leftOperand, Object rightOperand) {
        return leftOperand instanceof Double || rightOperand instanceof Double;
    }

    private static boolean isFloatComparisonDesired(Object leftOperand, Object rightOperand) {
        return leftOperand instanceof Float || rightOperand instanceof Float;
    }

    private static boolean isLongComparisonDesired(Object leftOperand, Object rightOperand) {
        return leftOperand instanceof Long || rightOperand instanceof Long;
    }

    private static boolean isIntegerComparisonDesired(Object leftOperand, Object rightOperand) {
        return leftOperand instanceof Integer || rightOperand instanceof Integer;
    }

    private static boolean isShortComparisonDesired(Object leftOperand, Object rightOperand) {
        return leftOperand instanceof Short || rightOperand instanceof Short;
    }

    private static boolean isByteComparisonDesired(Object leftOperand, Object rightOperand) {
        return leftOperand instanceof Byte || rightOperand instanceof Byte;
    }

    private static double doubleValue(Object o) {
        assert (o instanceof Number);
        return ((Number)o).doubleValue();
    }

    private static float floatValue(Object o) {
        assert (o instanceof Number);
        return ((Number)o).floatValue();
    }

    private static long longValue(Object o) {
        assert (o instanceof Number);
        return ((Number)o).longValue();
    }

    private static int intValue(Object o) {
        assert (o instanceof Number);
        return ((Number)o).intValue();
    }

    private static short shortValue(Object o) {
        assert (o instanceof Number);
        return ((Number)o).shortValue();
    }

    private static byte byteValue(Object o) {
        assert (o instanceof Number);
        return ((Number)o).byteValue();
    }

    public RelationalInfixExpression() {
    }

    public RelationalInfixExpression(Expression leftOperand, Operator operator, Expression rightOperand, AbstractType leftOperandType, AbstractType rightOperandType) {
        super(leftOperand, operator, rightOperand);
        this.leftOperandType.setValue(leftOperandType);
        this.rightOperandType.setValue(rightOperandType);
    }

    @Override
    protected AbstractType getLeftOperandType() {
        return (AbstractType)this.leftOperandType.getValue();
    }

    @Override
    protected AbstractType getRightOperandType() {
        return (AbstractType)this.rightOperandType.getValue();
    }

    @Override
    public AbstractType getType() {
        return TypeDeclaredInJava.BOOLEAN_OBJECT_TYPE;
    }

    @Override
    protected void handleMissingProperty(String propertyName, Object value) {
        assert (propertyName.equals("expressionType"));
        if (value == TypeDeclaredInJava.DOUBLE_OBJECT_TYPE) {
            value = TypeDeclaredInJava.get(Number.class);
        }
        this.leftOperandType.setValue((AbstractType)value);
        this.rightOperandType.setValue((AbstractType)value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        LESS{

            public Boolean operate(Object leftOperand, Object rightOperand) {
                if (RelationalInfixExpression.isNumberComparisonDesired(leftOperand, rightOperand)) {
                    assert (leftOperand != null);
                    assert (rightOperand != null);
                    if (RelationalInfixExpression.isDoubleComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.doubleValue(leftOperand) < RelationalInfixExpression.doubleValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isFloatComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.floatValue(leftOperand) < RelationalInfixExpression.floatValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isLongComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.longValue(leftOperand) < RelationalInfixExpression.longValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isIntegerComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.intValue(leftOperand) < RelationalInfixExpression.intValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isShortComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.shortValue(leftOperand) < RelationalInfixExpression.shortValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isByteComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.byteValue(leftOperand) < RelationalInfixExpression.byteValue(rightOperand);
                    }
                    throw new RuntimeException();
                }
                throw new RuntimeException();
            }
        }
        ,
        LESS_EQUALS{

            public Boolean operate(Object leftOperand, Object rightOperand) {
                if (RelationalInfixExpression.isNumberComparisonDesired(leftOperand, rightOperand)) {
                    assert (leftOperand != null);
                    assert (rightOperand != null);
                    if (RelationalInfixExpression.isDoubleComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.doubleValue(leftOperand) <= RelationalInfixExpression.doubleValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isFloatComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.floatValue(leftOperand) <= RelationalInfixExpression.floatValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isLongComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.longValue(leftOperand) <= RelationalInfixExpression.longValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isIntegerComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.intValue(leftOperand) <= RelationalInfixExpression.intValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isShortComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.shortValue(leftOperand) <= RelationalInfixExpression.shortValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isByteComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.byteValue(leftOperand) <= RelationalInfixExpression.byteValue(rightOperand);
                    }
                    throw new RuntimeException();
                }
                throw new RuntimeException();
            }
        }
        ,
        GREATER{

            public Boolean operate(Object leftOperand, Object rightOperand) {
                if (RelationalInfixExpression.isNumberComparisonDesired(leftOperand, rightOperand)) {
                    assert (leftOperand != null);
                    assert (rightOperand != null);
                    if (RelationalInfixExpression.isDoubleComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.doubleValue(leftOperand) > RelationalInfixExpression.doubleValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isFloatComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.floatValue(leftOperand) > RelationalInfixExpression.floatValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isLongComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.longValue(leftOperand) > RelationalInfixExpression.longValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isIntegerComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.intValue(leftOperand) > RelationalInfixExpression.intValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isShortComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.shortValue(leftOperand) > RelationalInfixExpression.shortValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isByteComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.byteValue(leftOperand) > RelationalInfixExpression.byteValue(rightOperand);
                    }
                    throw new RuntimeException();
                }
                throw new RuntimeException();
            }
        }
        ,
        GREATER_EQUALS{

            public Boolean operate(Object leftOperand, Object rightOperand) {
                if (RelationalInfixExpression.isNumberComparisonDesired(leftOperand, rightOperand)) {
                    assert (leftOperand != null);
                    assert (rightOperand != null);
                    if (RelationalInfixExpression.isDoubleComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.doubleValue(leftOperand) >= RelationalInfixExpression.doubleValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isFloatComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.floatValue(leftOperand) >= RelationalInfixExpression.floatValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isLongComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.longValue(leftOperand) >= RelationalInfixExpression.longValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isIntegerComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.intValue(leftOperand) >= RelationalInfixExpression.intValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isShortComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.shortValue(leftOperand) >= RelationalInfixExpression.shortValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isByteComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.byteValue(leftOperand) >= RelationalInfixExpression.byteValue(rightOperand);
                    }
                    throw new RuntimeException();
                }
                throw new RuntimeException();
            }
        }
        ,
        EQUALS{

            public Boolean operate(Object leftOperand, Object rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (RelationalInfixExpression.isNumberComparisonDesired(leftOperand, rightOperand)) {
                    assert (leftOperand != null);
                    assert (rightOperand != null);
                    if (RelationalInfixExpression.isDoubleComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.doubleValue(leftOperand) == RelationalInfixExpression.doubleValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isFloatComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.floatValue(leftOperand) == RelationalInfixExpression.floatValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isLongComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.longValue(leftOperand) == RelationalInfixExpression.longValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isIntegerComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.intValue(leftOperand) == RelationalInfixExpression.intValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isShortComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.shortValue(leftOperand) == RelationalInfixExpression.shortValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isByteComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.byteValue(leftOperand) == RelationalInfixExpression.byteValue(rightOperand);
                    }
                    throw new RuntimeException();
                }
                throw new RuntimeException();
            }
        }
        ,
        NOT_EQUALS{

            public Boolean operate(Object leftOperand, Object rightOperand) {
                if (RelationalInfixExpression.isNumberComparisonDesired(leftOperand, rightOperand)) {
                    assert (leftOperand != null);
                    assert (rightOperand != null);
                    if (RelationalInfixExpression.isDoubleComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.doubleValue(leftOperand) != RelationalInfixExpression.doubleValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isFloatComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.floatValue(leftOperand) != RelationalInfixExpression.floatValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isLongComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.longValue(leftOperand) != RelationalInfixExpression.longValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isIntegerComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.intValue(leftOperand) != RelationalInfixExpression.intValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isShortComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.shortValue(leftOperand) != RelationalInfixExpression.shortValue(rightOperand);
                    }
                    if (RelationalInfixExpression.isByteComparisonDesired(leftOperand, rightOperand)) {
                        return RelationalInfixExpression.byteValue(leftOperand) != RelationalInfixExpression.byteValue(rightOperand);
                    }
                    throw new RuntimeException();
                }
                throw new RuntimeException();
            }
        };


        public abstract Boolean operate(Object var1, Object var2);
    }
}

