/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.project;

import edu.cmu.cs.dennisc.alice.Project;
import edu.cmu.cs.dennisc.alice.Version;
import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.Node;
import edu.cmu.cs.dennisc.alice.ast.ResourceExpression;
import edu.cmu.cs.dennisc.io.FileUtilities;
import edu.cmu.cs.dennisc.io.InputStreamUtilities;
import edu.cmu.cs.dennisc.lang.ClassUtilities;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.pattern.IsInstanceCrawler;
import edu.cmu.cs.dennisc.pattern.Tuple2;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.xml.XMLUtilities;
import edu.cmu.cs.dennisc.zip.ByteArrayDataSource;
import edu.cmu.cs.dennisc.zip.DataSource;
import edu.cmu.cs.dennisc.zip.ZipUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.alice.virtualmachine.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectUtilities {
    public static final String PROJECT_EXTENSION = "a3p";
    public static final String TYPE_EXTENSION = "a3c";
    private static String PROPERTIES_ENTRY_NAME = "properties.bin";
    private static String PROGRAM_TYPE_ENTRY_NAME = "programType.xml";
    private static String VERSION_ENTRY_NAME = "version.txt";
    private static String TYPE_ENTRY_NAME = "type.xml";
    private static String RESOURCES_ENTRY_NAME = "resources.xml";
    private static String XML_RESOURCE_TAG_NAME = "resource";
    private static String XML_RESOURCE_CLASSNAME_ATTRIBUTE = "className";
    private static String XML_RESOURCE_UUID_ATTRIBUTE = "uuid";
    private static String XML_RESOURCE_ENTRY_NAME_ATTRIBUTE = "entryName";

    private ProjectUtilities() {
    }

    public static Set<Resource> getReferencedResources(Project project) {
        AbstractType programType = project.getProgramType();
        Set<Resource> resources = project.getResources();
        IsInstanceCrawler<ResourceExpression> crawler = new IsInstanceCrawler<ResourceExpression>(ResourceExpression.class){

            @Override
            protected boolean isAcceptable(ResourceExpression resourceExpression) {
                return true;
            }
        };
        programType.crawl(crawler, true);
        HashSet<Resource> rv = new HashSet<Resource>();
        for (ResourceExpression resourceExpression : crawler.getList()) {
            Resource resource = (Resource)resourceExpression.resource.getValue();
            if (!resources.contains(resource)) {
                PrintUtilities.println("WARNING: adding missing resource", resource);
                resources.add(resource);
            }
            rv.add(resource);
        }
        return rv;
    }

    public static File getMyAliceDirectory(String applicationName) {
        File rv = new File(FileUtilities.getDefaultDirectory(), applicationName);
        rv.mkdirs();
        return rv;
    }

    public static File getMyProjectsDirectory(String applicationName) {
        File rv = new File(ProjectUtilities.getMyAliceDirectory(applicationName), "MyProjects");
        rv.mkdirs();
        return rv;
    }

    public static File getMyTypesDirectory(String applicationName) {
        File rv = new File(ProjectUtilities.getMyAliceDirectory(applicationName), "MyClasses");
        rv.mkdirs();
        return rv;
    }

    @Deprecated
    public static File getMyAliceDirectory() {
        return ProjectUtilities.getMyAliceDirectory("Alice3");
    }

    @Deprecated
    public static File getMyProjectsDirectory() {
        return ProjectUtilities.getMyProjectsDirectory("Alice3");
    }

    @Deprecated
    public static File getMyTypesDirectory() {
        return ProjectUtilities.getMyTypesDirectory("Alice3");
    }

    public static File[] listProjectFiles(File directory) {
        return FileUtilities.listFiles(directory, PROJECT_EXTENSION);
    }

    public static File[] listTypeFiles(File directory) {
        return FileUtilities.listFiles(directory, TYPE_EXTENSION);
    }

    private static String readVersion(ZipFile zipFile) throws IOException {
        assert (zipFile != null);
        ZipEntry entry = zipFile.getEntry(VERSION_ENTRY_NAME);
        if (entry != null) {
            int b;
            InputStream is = zipFile.getInputStream(entry);
            ArrayList<Byte> buffer = new ArrayList<Byte>(32);
            while ((b = is.read()) != -1) {
                buffer.add((byte)b);
            }
            byte[] array = new byte[buffer.size()];
            int i = 0;
            for (Byte b2 : buffer) {
                array[i++] = b2;
            }
            return new String(array);
        }
        throw new IOException(zipFile.getName() + " does not contain entry " + VERSION_ENTRY_NAME);
    }

    private static Project.Properties readProperties(Project.Properties rv, ZipFile zipFile) throws IOException {
        assert (zipFile != null);
        ZipEntry entry = zipFile.getEntry(PROPERTIES_ENTRY_NAME);
        if (entry != null) {
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
            rv.read(bis);
        }
        return rv;
    }

    private static Document readXML(ZipFile zipFile, String entryName) throws IOException {
        assert (zipFile != null);
        ZipEntry entry = zipFile.getEntry(entryName);
        assert (entry != null);
        return XMLUtilities.read(zipFile.getInputStream(entry));
    }

    private static AbstractType readType(ZipFile zipFile, String entryName) throws IOException {
        String version = ProjectUtilities.readVersion(zipFile);
        Document xmlDocument = ProjectUtilities.readXML(zipFile, entryName);
        return (AbstractType)Node.decode(xmlDocument, version);
    }

    private static Set<Resource> readResources(ZipFile zipFile) throws IOException {
        HashSet<Resource> rv = new HashSet<Resource>();
        ZipEntry zeResources = zipFile.getEntry(RESOURCES_ENTRY_NAME);
        if (zeResources != null) {
            Document xmlDocument = XMLUtilities.read(zipFile.getInputStream(zeResources));
            List<Element> xmlElements = XMLUtilities.getChildElementsByTagName(xmlDocument.getDocumentElement(), XML_RESOURCE_TAG_NAME);
            for (Element xmlElement : xmlElements) {
                String className = xmlElement.getAttribute(XML_RESOURCE_CLASSNAME_ATTRIBUTE);
                String uuidText = xmlElement.getAttribute(XML_RESOURCE_UUID_ATTRIBUTE);
                String entryName = xmlElement.getAttribute(XML_RESOURCE_ENTRY_NAME_ATTRIBUTE);
                if (className == null || uuidText == null || entryName == null) continue;
                ZipEntry zipEntry = zipFile.getEntry(entryName);
                byte[] data = InputStreamUtilities.getBytes(zipFile.getInputStream(zipEntry));
                if (data != null) {
                    try {
                        Class<?> resourceCls = ClassUtilities.forName(className);
                        Resource resource = (Resource)ReflectionUtilities.valueOf(resourceCls, uuidText);
                        resource.decodeAttributes(xmlElement, data);
                        rv.add(resource);
                    }
                    catch (ClassNotFoundException cnfe) {
                        PrintUtilities.println("WARNING: no class for name:", className);
                    }
                    continue;
                }
                PrintUtilities.println("WARNING: no data for resource:", entryName);
            }
        }
        return rv;
    }

    public static Project readProject(ZipFile zipFile) throws IOException {
        assert (zipFile != null);
        AbstractType type = ProjectUtilities.readType(zipFile, PROGRAM_TYPE_ENTRY_NAME);
        Set<Resource> resources = ProjectUtilities.readResources(zipFile);
        Project rv = new Project(type, resources);
        ProjectUtilities.readProperties(rv.getProperties(), zipFile);
        return rv;
    }

    public static Project readProject(File file) {
        assert (file != null);
        assert (file.exists());
        try {
            return ProjectUtilities.readProject(new ZipFile(file));
        }
        catch (IOException ioe) {
            throw new RuntimeException(file.getAbsolutePath(), ioe);
        }
    }

    public static Project readProject(String path) {
        assert (path != null);
        return ProjectUtilities.readProject(new File(path));
    }

    public static Tuple2<AbstractType, Set<Resource>> readType(ZipFile zipFile) throws IOException {
        AbstractType type = ProjectUtilities.readType(zipFile, TYPE_ENTRY_NAME);
        Set<Resource> resources = ProjectUtilities.readResources(zipFile);
        return new Tuple2<AbstractType, Set<Resource>>(type, resources);
    }

    public static Tuple2<AbstractType, Set<Resource>> readType(File file) {
        assert (file != null);
        assert (file.exists());
        try {
            return ProjectUtilities.readType(new ZipFile(file));
        }
        catch (IOException ioe) {
            throw new RuntimeException(file.getAbsolutePath(), ioe);
        }
    }

    public static Tuple2<AbstractType, Set<Resource>> readType(String path) {
        return ProjectUtilities.readType(new File(path));
    }

    private static void writeVersion(ZipOutputStream zos) throws IOException {
        ZipUtilities.write(zos, new DataSource(){

            public String getName() {
                return VERSION_ENTRY_NAME;
            }

            public void write(OutputStream os) throws IOException {
                os.write(Version.getCurrentVersionText().getBytes());
            }
        });
    }

    private static void writeXML(final Document xmlDocument, ZipOutputStream zos, final String entryName) throws IOException {
        ZipUtilities.write(zos, new DataSource(){

            public String getName() {
                return entryName;
            }

            public void write(OutputStream os) throws IOException {
                XMLUtilities.write(xmlDocument, os);
            }
        });
    }

    private static void writeType(AbstractType type, ZipOutputStream zos, String entryName) throws IOException {
        ProjectUtilities.writeXML(type.encode(), zos, entryName);
    }

    private static void writeDataSources(ZipOutputStream zos, DataSource ... dataSources) throws IOException {
        for (DataSource dataSource : dataSources) {
            ZipUtilities.write(zos, dataSource);
        }
    }

    private static String getValidName(String name) {
        return name;
    }

    private static String generateEntryName(Resource resource, Set<String> usedEntryNames) {
        String potentialEntryName;
        String validFilename = ProjectUtilities.getValidName(resource.getOriginalFileName());
        String DESIRED_DIRECTORY_NAME = "resources";
        int i = 1;
        while (true) {
            StringBuffer sb = new StringBuffer();
            sb.append("resources");
            if (i > 1) {
                sb.append(i);
            }
            sb.append("/");
            sb.append(validFilename);
            potentialEntryName = sb.toString();
            if (!usedEntryNames.contains(potentialEntryName)) break;
            ++i;
        }
        return potentialEntryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResources(ZipOutputStream zos, Set<Resource> resources) throws IOException {
        if (!resources.isEmpty()) {
            HashSet<String> usedEntryNames;
            Document xmlDocument = XMLUtilities.createDocument();
            Element xmlRootElement = xmlDocument.createElement("root");
            xmlDocument.appendChild(xmlRootElement);
            Set<Resource> set = resources;
            synchronized (set) {
                usedEntryNames = new HashSet<String>();
                for (Resource resource : resources) {
                    Element xmlElement = xmlDocument.createElement(XML_RESOURCE_TAG_NAME);
                    resource.encodeAttributes(xmlElement);
                    UUID uuid = resource.getUUID();
                    assert (uuid != null);
                    xmlElement.setAttribute(XML_RESOURCE_CLASSNAME_ATTRIBUTE, resource.getClass().getName());
                    xmlElement.setAttribute(XML_RESOURCE_UUID_ATTRIBUTE, uuid.toString());
                    String entryName = ProjectUtilities.generateEntryName(resource, usedEntryNames);
                    usedEntryNames.add(entryName);
                    xmlElement.setAttribute(XML_RESOURCE_ENTRY_NAME_ATTRIBUTE, entryName);
                    xmlRootElement.appendChild(xmlElement);
                }
            }
            ProjectUtilities.writeXML(xmlDocument, zos, RESOURCES_ENTRY_NAME);
            set = resources;
            synchronized (set) {
                usedEntryNames = new HashSet();
                for (Resource resource : resources) {
                    String entryName = ProjectUtilities.generateEntryName(resource, usedEntryNames);
                    usedEntryNames.add(entryName);
                    ZipUtilities.write(zos, new ByteArrayDataSource(entryName, resource.getData()));
                }
            }
        }
    }

    public static void writeProject(OutputStream os, Project project, DataSource ... dataSources) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        ProjectUtilities.writeVersion(zos);
        AbstractType programType = project.getProgramType();
        ProjectUtilities.writeType(programType, zos, PROGRAM_TYPE_ENTRY_NAME);
        final Project.Properties properties = project.getProperties();
        if (properties != null) {
            ZipUtilities.write(zos, new DataSource(){

                public String getName() {
                    return PROPERTIES_ENTRY_NAME;
                }

                public void write(OutputStream os) throws IOException {
                    assert (os instanceof BufferedOutputStream);
                    properties.write((BufferedOutputStream)os);
                }
            });
        }
        ProjectUtilities.writeDataSources(zos, dataSources);
        Set<Resource> resources = project.getResources();
        IsInstanceCrawler<ResourceExpression> crawler = new IsInstanceCrawler<ResourceExpression>(ResourceExpression.class){

            @Override
            protected boolean isAcceptable(ResourceExpression resourceExpression) {
                return true;
            }
        };
        programType.crawl(crawler, true);
        for (ResourceExpression resourceExpression : crawler.getList()) {
            Resource resource = (Resource)resourceExpression.resource.getValue();
            if (resources.contains(resource)) continue;
            PrintUtilities.println("WARNING: adding missing resource", resource);
            resources.add(resource);
        }
        ProjectUtilities.writeResources(zos, resources);
        zos.flush();
        zos.close();
    }

    public static void writeProject(File file, Project project, DataSource ... dataSources) throws IOException {
        FileUtilities.createParentDirectoriesIfNecessary(file);
        ProjectUtilities.writeProject(new FileOutputStream(file), project, dataSources);
    }

    public static void writeProject(String path, Project project, DataSource ... dataSources) throws IOException {
        ProjectUtilities.writeProject(new File(path), project, dataSources);
    }

    public static void writeType(OutputStream os, AbstractType type, DataSource ... dataSources) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        ProjectUtilities.writeVersion(zos);
        ProjectUtilities.writeType(type, zos, TYPE_ENTRY_NAME);
        ProjectUtilities.writeDataSources(zos, dataSources);
        IsInstanceCrawler<ResourceExpression> crawler = new IsInstanceCrawler<ResourceExpression>(ResourceExpression.class){

            @Override
            protected boolean isAcceptable(ResourceExpression resourceExpression) {
                return true;
            }
        };
        type.crawl(crawler, false);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ResourceExpression resourceExpression : crawler.getList()) {
            resources.add((Resource)resourceExpression.resource.getValue());
        }
        ProjectUtilities.writeResources(zos, resources);
        zos.flush();
        zos.close();
    }

    public static void writeType(File file, AbstractType type, DataSource ... dataSources) throws IOException {
        FileUtilities.createParentDirectoriesIfNecessary(file);
        ProjectUtilities.writeType(new FileOutputStream(file), type, dataSources);
    }

    public static void writeType(String path, AbstractType type, DataSource ... dataSources) throws IOException {
        ProjectUtilities.writeType(new File(path), type, dataSources);
    }
}

