/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.reflect;

import edu.cmu.cs.dennisc.alice.reflect.ClassInfo;
import edu.cmu.cs.dennisc.alice.reflect.MethodInfo;
import edu.cmu.cs.dennisc.codec.CodecUtilities;
import edu.cmu.cs.dennisc.io.FileUtilities;
import edu.cmu.cs.dennisc.pattern.LazilyInitialized;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassInfoManager {
    private static Map<String, LazilyInitialized<ClassInfo>> s_map = new HashMap<String, LazilyInitialized<ClassInfo>>();

    private ClassInfoManager() {
    }

    public static void addClassInfosFrom(File file) {
        assert (file != null);
        if (file.isDirectory()) {
            for (final File f : file.listFiles()) {
                String clsName = FileUtilities.getBaseName(f);
                s_map.put(clsName, new LazilyInitialized<ClassInfo>(){

                    @Override
                    protected ClassInfo initialize() {
                        return CodecUtilities.decodeBinary(f, ClassInfo.class);
                    }
                });
            }
        } else {
            try {
                ZipFile zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry zipEntry = e.nextElement();
                    final InputStream is = zipFile.getInputStream(zipEntry);
                    String clsName = FileUtilities.getBaseName(zipEntry.getName());
                    s_map.put(clsName, new LazilyInitialized<ClassInfo>(){

                        @Override
                        protected ClassInfo initialize() {
                            return CodecUtilities.decodeBinary(is, ClassInfo.class);
                        }
                    });
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static ClassInfo get(Class<?> cls) {
        if (cls != null) {
            LazilyInitialized<ClassInfo> lazyClassInfo = s_map.get(cls.getName());
            if (lazyClassInfo != null) {
                return lazyClassInfo.get();
            }
            return null;
        }
        return null;
    }

    public static String[] getParameterNamesFor(Method mthd) {
        ClassInfo clsInfo = ClassInfoManager.get(mthd.getDeclaringClass());
        if (clsInfo != null) {
            MethodInfo methodInfo = clsInfo.lookupInfo(mthd);
            if (methodInfo != null) {
                return methodInfo.getParameterNames();
            }
            return null;
        }
        return null;
    }

    public static Iterable<MethodInfo> getMethodInfos(Class<?> cls) {
        ClassInfo clsInfo = ClassInfoManager.get(cls);
        if (clsInfo != null) {
            return clsInfo.getMethodInfos();
        }
        return null;
    }
}

