/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.virtualmachine;

import edu.cmu.cs.dennisc.alice.ast.AbstractField;
import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.ClassReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.ConstructorDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.Expression;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;
import edu.cmu.cs.dennisc.alice.virtualmachine.VirtualMachine;
import edu.cmu.cs.dennisc.lang.ClassUtilities;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceInAlice {
    private Map<FieldDeclaredInAlice, Object> m_map = new HashMap<FieldDeclaredInAlice, Object>();
    private Object m_instanceInJava;
    private AbstractType m_type;

    public void initialize(VirtualMachine vm, ConstructorDeclaredInAlice constructor, Object[] arguments) {
        this.m_type = constructor.getDeclaringType();
        assert (this.m_type != null);
        assert (this.m_type instanceof TypeDeclaredInAlice);
        assert (arguments.length == 0);
        AbstractType t = this.m_type;
        while (t instanceof TypeDeclaredInAlice) {
            for (AbstractField abstractField : t.getDeclaredFields()) {
                assert (abstractField instanceof FieldDeclaredInAlice);
                FieldDeclaredInAlice fieldDeclaredInAlice = (FieldDeclaredInAlice)abstractField;
                this.set(fieldDeclaredInAlice, vm.evaluate((Expression)fieldDeclaredInAlice.initializer.getValue()));
            }
            t = t.getSuperType();
        }
        assert (t instanceof TypeDeclaredInJava);
        TypeDeclaredInJava typeDeclaredInJava = (TypeDeclaredInJava)t;
        ClassReflectionProxy classReflectionProxy = typeDeclaredInJava.getClassReflectionProxy();
        assert (classReflectionProxy != null);
        Class cls = (Class)classReflectionProxy.getReification();
        assert (cls != null) : classReflectionProxy.getName();
        this.m_instanceInJava = ReflectionUtilities.newInstance(cls);
    }

    public AbstractType getType() {
        return this.m_type;
    }

    public Object getInstanceInJava() {
        return this.m_instanceInJava;
    }

    public <E> E getInstanceInJava(Class<E> cls) {
        return ClassUtilities.getInstance(this.m_instanceInJava, cls);
    }

    public Object get(FieldDeclaredInAlice field) {
        return this.m_map.get(field);
    }

    public void set(FieldDeclaredInAlice field, Object value) {
        this.m_map.put(field, value);
    }

    public String toString() {
        if (this.m_instanceInJava != null) {
            return this.m_instanceInJava.toString();
        }
        return null;
    }
}

