/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;

public abstract class AbstractAnimation
implements Animation {
    private State m_state = State.PROLOGUE_IS_REQUIRED;
    private double m_t0 = Double.NaN;
    private double m_tPrevious = Double.NaN;

    public final void reset() {
        this.m_state = State.INITIALIZE_IS_REQUIRED;
    }

    public final double update(double tCurrent, AnimationObserver animationObserver) {
        double tRemaining = Double.NaN;
        if (this.m_state != State.COMPLETED) {
            if (this.m_state == State.INITIALIZE_IS_REQUIRED) {
                this.m_t0 = Double.NaN;
                this.m_tPrevious = Double.NaN;
                this.m_state = State.PROLOGUE_IS_REQUIRED;
            }
            if (this.m_state == State.PROLOGUE_IS_REQUIRED) {
                this.m_t0 = tCurrent;
                this.prologue();
                if (animationObserver != null) {
                    animationObserver.started(this);
                }
                this.m_state = State.UPDATE_IS_REQUIRED;
            }
            if (this.m_state == State.UPDATE_IS_REQUIRED) {
                tRemaining = this.update(tCurrent - this.m_t0, tCurrent - this.m_tPrevious, animationObserver);
                if (tRemaining <= 0.0) {
                    this.m_state = State.EPILOGUE_IS_REQUIRED;
                }
                this.m_tPrevious = tCurrent;
            }
            if (this.m_state == State.EPILOGUE_IS_REQUIRED) {
                this.epilogue();
                if (animationObserver != null) {
                    animationObserver.finished(this);
                }
                this.m_state = State.COMPLETED;
            }
        } else {
            tRemaining = 0.0;
        }
        assert (!Double.isNaN(tRemaining));
        return tRemaining;
    }

    public void complete(AnimationObserver animationObserver) {
        if (this.m_state == State.PROLOGUE_IS_REQUIRED) {
            this.prologue();
            if (animationObserver != null) {
                animationObserver.started(this);
            }
            this.m_state = State.UPDATE_IS_REQUIRED;
        }
        if (this.m_state == State.UPDATE_IS_REQUIRED) {
            this.update(0.0, 0.0, animationObserver);
            this.m_state = State.EPILOGUE_IS_REQUIRED;
        }
        if (this.m_state == State.EPILOGUE_IS_REQUIRED) {
            this.epilogue();
            if (animationObserver != null) {
                animationObserver.finished(this);
            }
            this.m_state = State.PROLOGUE_IS_REQUIRED;
        }
    }

    protected abstract void prologue();

    protected abstract double update(double var1, double var3, AnimationObserver var5);

    protected abstract void epilogue();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIALIZE_IS_REQUIRED,
        PROLOGUE_IS_REQUIRED,
        UPDATE_IS_REQUIRED,
        EPILOGUE_IS_REQUIRED,
        COMPLETED;

    }
}

