/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;
import edu.cmu.cs.dennisc.animation.AnimationThread;
import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.animation.WaitingAnimation;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractAnimator
implements Animator {
    private List<WaitingAnimation> m_waitingAnimations = new LinkedList<WaitingAnimation>();
    private double m_speedFactor = 1.0;
    private double m_tCurrent;

    protected abstract void updateCurrentTime(boolean var1);

    protected final void setCurrentTime(double tCurrent) {
        this.m_tCurrent = tCurrent;
    }

    public final double getCurrentTime() {
        return this.m_tCurrent;
    }

    public double getSpeedFactor() {
        return this.m_speedFactor;
    }

    public void setSpeedFactor(double speedFactor) {
        this.m_speedFactor = speedFactor;
    }

    public boolean isUpdateRequired() {
        return !this.m_waitingAnimations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        List<WaitingAnimation> list = this.m_waitingAnimations;
        synchronized (list) {
            boolean isPaused = this.m_speedFactor <= 0.0;
            this.updateCurrentTime(isPaused);
            if (!isPaused) {
                double tCurrent = this.getCurrentTime();
                if (this.m_waitingAnimations.size() > 0) {
                    Iterator<WaitingAnimation> iterator = this.m_waitingAnimations.iterator();
                    while (iterator.hasNext()) {
                        WaitingAnimation waitingAnimation = iterator.next();
                        double tRemaining = waitingAnimation.getAnimation().update(tCurrent, waitingAnimation.getAnimationObserver());
                        if (tRemaining > 0.0) continue;
                        Thread thread = waitingAnimation.getThread();
                        if (thread != null) {
                            Thread thread2 = thread;
                            synchronized (thread2) {
                                thread.notify();
                            }
                        }
                        iterator.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(AnimationObserver animationObserver) {
        List<WaitingAnimation> list = this.m_waitingAnimations;
        synchronized (list) {
            Iterator<WaitingAnimation> iterator = this.m_waitingAnimations.iterator();
            while (iterator.hasNext()) {
                WaitingAnimation waitingAnimation = iterator.next();
                waitingAnimation.getAnimation().complete(waitingAnimation.getAnimationObserver());
                Thread thread = waitingAnimation.getThread();
                if (thread != null) {
                    Thread thread2 = thread;
                    synchronized (thread2) {
                        thread.notify();
                    }
                }
                iterator.remove();
            }
        }
    }

    protected WaitingAnimation createWaitingAnimation(Animation animation, AnimationObserver animationObserver, Thread currentThread) {
        return new WaitingAnimation(animation, animationObserver, currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Animation animation, AnimationObserver animationObserver) {
        WaitingAnimation waitingAnimation = this.createWaitingAnimation(animation, animationObserver, null);
        List<WaitingAnimation> list = this.m_waitingAnimations;
        synchronized (list) {
            this.m_waitingAnimations.add(waitingAnimation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Animation animation, AnimationObserver animationObserver) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            PrintUtilities.println("FYI: Animation called from AWT event dispatch thread.  Launching as separate thread.");
            new AnimationThread(this, animation, animationObserver).start();
        } else {
            Thread currentThread = Thread.currentThread();
            WaitingAnimation waitingAnimation = this.createWaitingAnimation(animation, animationObserver, currentThread);
            Thread thread = currentThread;
            synchronized (thread) {
                List<WaitingAnimation> list = this.m_waitingAnimations;
                synchronized (list) {
                    this.m_waitingAnimations.add(waitingAnimation);
                }
                currentThread.wait();
            }
            if (waitingAnimation.getException() != null) {
                throw new InvocationTargetException(waitingAnimation.getException());
            }
        }
    }

    public void invokeAndWait_ThrowRuntimeExceptionsIfNecessary(Animation animation, AnimationObserver animationObserver) {
        try {
            this.invokeAndWait(animation, animationObserver);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (InvocationTargetException ie) {
            throw new RuntimeException(ie);
        }
    }
}

