/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;

public abstract class CompositeAnimation
implements Animation {
    private Animation[] m_animations;

    public CompositeAnimation(Animation ... animations) {
        this.setAnimations(animations);
    }

    protected void setAnimations(Animation[] animations) {
        this.m_animations = animations;
        this.reset();
    }

    public Animation[] getAnimations() {
        return this.m_animations;
    }

    public void reset() {
        for (Animation animation : this.m_animations) {
            animation.reset();
        }
    }

    public void complete(AnimationObserver animationObserver) {
        for (Animation animation : this.m_animations) {
            animation.complete(animationObserver);
        }
    }
}

