/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.AbstractAnimation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;
import edu.cmu.cs.dennisc.animation.BreakException;
import edu.cmu.cs.dennisc.animation.DurationBasedAnimationObserver;
import edu.cmu.cs.dennisc.animation.Style;
import edu.cmu.cs.dennisc.animation.TraditionalStyle;

public abstract class DurationBasedAnimation
extends AbstractAnimation {
    public static final double DEFAULT_DURATION = 1.0;
    public static final Style DEFAULT_STYLE = TraditionalStyle.BEGIN_AND_END_GENTLY;
    private double m_duration;
    private Style m_style;

    public DurationBasedAnimation() {
        this(1.0);
    }

    public DurationBasedAnimation(Number duration) {
        this(duration, DEFAULT_STYLE);
    }

    public DurationBasedAnimation(Number duration, Style style) {
        this.setDuration(duration);
        this.setStyle(style);
    }

    public double getDuration() {
        return this.m_duration;
    }

    public void setDuration(Number duration) {
        this.m_duration = duration.doubleValue();
    }

    public Style getStyle() {
        return this.m_style;
    }

    public void setStyle(Style style) {
        assert (style != null);
        this.m_style = style;
    }

    protected double update(double deltaSincePrologue, double deltaSinceLastUpdate, AnimationObserver animationObserver) {
        double portion = this.m_duration > 0.0 ? this.m_style.calculatePortion(deltaSincePrologue, this.m_duration) : 1.0;
        double tRemaining = this.m_duration - deltaSincePrologue;
        this.setPortion(portion);
        if (animationObserver instanceof DurationBasedAnimationObserver) {
            try {
                ((DurationBasedAnimationObserver)animationObserver).updated(this, portion);
            }
            catch (BreakException be) {
                tRemaining = 0.0;
            }
        }
        return tRemaining;
    }

    protected abstract void setPortion(double var1);
}

