/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.AbstractAnimation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;
import edu.cmu.cs.dennisc.animation.BreakException;
import edu.cmu.cs.dennisc.animation.FrameBasedAnimationObserver;

public abstract class FrameBasedAnimation
extends AbstractAnimation {
    private int m_iPrevious;
    private int m_iCurrent;

    public abstract int getFrameCount();

    public abstract double getFramesPerSecond();

    protected double getDurationPerFrame() {
        return 1.0 / this.getFramesPerSecond();
    }

    protected double getDuration() {
        return (double)this.getFrameCount() * this.getDurationPerFrame();
    }

    protected abstract boolean isSkippingFramesAcceptable();

    protected double update(double deltaSincePrologue, double deltaSinceLastUpdate, AnimationObserver animationObserver) {
        double tDuration = this.getDuration();
        double tRemaining = tDuration - deltaSincePrologue;
        double tDurationPerFrame = this.getDurationPerFrame();
        this.m_iCurrent = (int)((deltaSincePrologue + 0.5 * tDurationPerFrame) / tDurationPerFrame);
        this.m_iCurrent = Math.min(this.m_iCurrent, this.getFrameCount() - 1);
        if (this.m_iPrevious != this.m_iCurrent) {
            int init = this.m_iCurrent < this.m_iPrevious ? 0 : (this.isSkippingFramesAcceptable() ? this.m_iCurrent : this.m_iPrevious + 1);
            for (int i = init; i <= this.m_iCurrent; ++i) {
                this.setFrameIndex(i);
            }
            if (animationObserver instanceof FrameBasedAnimationObserver) {
                try {
                    ((FrameBasedAnimationObserver)animationObserver).updated(this, this.m_iCurrent);
                }
                catch (BreakException be) {
                    tRemaining = 0.0;
                }
            }
            this.m_iPrevious = this.m_iCurrent;
        }
        return tRemaining;
    }

    protected abstract void setFrameIndex(int var1);
}

