/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation.affine;

import edu.cmu.cs.dennisc.animation.affine.AffineAnimation;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.scenegraph.AbstractTransformable;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;

public class OrientationAnimation
extends AffineAnimation {
    public static final UnitQuaternion USE_EXISTING_VALUE_AT_RUN_TIME = null;
    private UnitQuaternion m_quatBegin = UnitQuaternion.createNaN();
    private UnitQuaternion m_quatEnd = UnitQuaternion.createNaN();
    private UnitQuaternion m_quatBeginUsedAtRuntime = UnitQuaternion.createNaN();

    public OrientationAnimation() {
        this.m_quatBeginUsedAtRuntime.setNaN();
        this.m_quatBegin.setNaN();
        this.m_quatEnd.setNaN();
    }

    public OrientationAnimation(AbstractTransformable sgSubject, ReferenceFrame sgAsSeenBy, UnitQuaternion quatBegin, UnitQuaternion quatEnd) {
        super(sgSubject, sgAsSeenBy);
        this.m_quatBeginUsedAtRuntime.setNaN();
        this.setOrientationBegin(quatBegin);
        this.setOrientationEnd(quatEnd);
    }

    public UnitQuaternion accessOrientationBeginUsedAtRuntime() {
        return this.m_quatBeginUsedAtRuntime;
    }

    public UnitQuaternion getOrientationBeginUsedAtRuntime(UnitQuaternion rv) {
        rv.setValue(this.m_quatBeginUsedAtRuntime);
        return rv;
    }

    public UnitQuaternion getOrientationBeginUsedAtRuntime() {
        return this.getOrientationBeginUsedAtRuntime(UnitQuaternion.createNaN());
    }

    public UnitQuaternion accessOrientationBegin() {
        return this.m_quatBegin;
    }

    public UnitQuaternion getOrientationBegin(UnitQuaternion rv) {
        rv.setValue(this.m_quatBegin);
        return rv;
    }

    public UnitQuaternion getOrientationBegin() {
        return this.getOrientationBegin(UnitQuaternion.createNaN());
    }

    public void setOrientationBegin(UnitQuaternion quatBegin) {
        if (quatBegin != USE_EXISTING_VALUE_AT_RUN_TIME) {
            this.m_quatBegin.setValue(quatBegin);
        } else {
            this.m_quatBegin.setNaN();
        }
    }

    public UnitQuaternion accessOrientationEnd() {
        return this.m_quatEnd;
    }

    public UnitQuaternion getOrientationEnd(UnitQuaternion rv) {
        rv.setValue(this.m_quatEnd);
        return rv;
    }

    public UnitQuaternion getOrientationEnd() {
        return this.getOrientationEnd(UnitQuaternion.createNaN());
    }

    public void setOrientationEnd(UnitQuaternion quatEnd) {
        this.m_quatEnd.setValue(quatEnd);
    }

    public void prologue() {
        if (this.m_quatBegin.isNaN()) {
            this.m_quatBeginUsedAtRuntime.setValue(this.getSubject().getAxes(this.getAsSeenBy()));
        } else {
            this.m_quatBeginUsedAtRuntime.setValue(this.m_quatBegin);
        }
    }

    public void setPortion(double portion) {
        this.getSubject().setAxesOnly(InterpolationUtilities.interpolate(this.m_quatBeginUsedAtRuntime, this.m_quatEnd, portion), this.getAsSeenBy());
    }

    public void epilogue() {
        this.getSubject().setAxesOnly(this.m_quatEnd, this.getAsSeenBy());
        this.m_quatBeginUsedAtRuntime.setNaN();
    }
}

