/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorUtilities {
    private static final Map<Component, Stack<Cursor>> mapComponentToStack = new HashMap<Component, Stack<Cursor>>();
    public static final Cursor NULL_CURSOR;

    private static Stack<Cursor> getStack(Component component) {
        Stack<Cursor> rv = mapComponentToStack.get(component);
        if (rv == null) {
            rv = new Stack();
            mapComponentToStack.put(component, rv);
        }
        return rv;
    }

    public static void pushAndSet(Component component, Cursor nextCursor) {
        if (nextCursor == null) {
            nextCursor = NULL_CURSOR;
        }
        Stack<Cursor> stack = CursorUtilities.getStack(component);
        Cursor prevCursor = component.getCursor();
        stack.push(prevCursor);
        component.setCursor(nextCursor);
    }

    public static Cursor popAndSet(Component component) {
        Stack<Cursor> stack = CursorUtilities.getStack(component);
        Cursor prevCursor = stack.pop();
        component.setCursor(prevCursor);
        return prevCursor;
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        MemoryImageSource source = new MemoryImageSource(1, 1, new int[]{0}, 0, 1);
        Image nullImage = toolkit.createImage(source);
        NULL_CURSOR = toolkit.createCustomCursor(nullImage, new Point(0, 0), "NULL_CURSOR");
    }
}

