/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.io.FileUtilities;
import edu.cmu.cs.dennisc.map.MapToMap;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class FileDialogUtilities {
    private static MapToMap<Component, String, FileDialog> mapPathToFileDialog = new MapToMap();
    private static Map<String, String> mapSecondaryKeyToPath = new HashMap<String, String>();

    private static File showFileDialog(Component component, String title, int mode, String directoryPath, String filename, String extension, boolean isSharingDesired) {
        File rv;
        String path;
        Component root = SwingUtilities.getRoot(component);
        String secondaryKey = directoryPath != null ? directoryPath : "null";
        FileDialog fileDialog = isSharingDesired ? mapPathToFileDialog.get(component, secondaryKey) : null;
        if (fileDialog == null) {
            fileDialog = root instanceof Frame ? new FileDialog((Frame)root, title, mode) : (root instanceof Dialog ? new FileDialog((Dialog)root, title, mode) : new FileDialog((Dialog)null, title, mode));
            if (isSharingDesired) {
                mapPathToFileDialog.put(component, secondaryKey, fileDialog);
            }
        }
        if (filename != null) {
            fileDialog.setFile(filename);
        }
        if ((path = isSharingDesired ? mapSecondaryKeyToPath.get(secondaryKey) : null) == null) {
            path = directoryPath;
        }
        if (path != null) {
            fileDialog.setDirectory(path);
        }
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        if (fileName != null) {
            String requestedDirectoryPath = fileDialog.getDirectory();
            if (isSharingDesired) {
                mapSecondaryKeyToPath.put(secondaryKey, requestedDirectoryPath);
            }
            File directory = new File(requestedDirectoryPath);
            if (mode == 1 && !fileName.endsWith("." + extension)) {
                fileName = fileName + "." + extension;
            }
            rv = new File(directory, fileName);
        } else {
            rv = null;
        }
        return rv;
    }

    public static File showOpenFileDialog(Component component, String directoryPath, String filename, String extension, boolean isSharingDesired) {
        return FileDialogUtilities.showFileDialog(component, "Open...", 0, directoryPath, filename, extension, isSharingDesired);
    }

    public static File showSaveFileDialog(Component component, String directoryPath, String filename, String extension, boolean isSharingDesired) {
        return FileDialogUtilities.showFileDialog(component, "Save...", 1, directoryPath, filename, extension, isSharingDesired);
    }

    public static File showOpenFileDialog(Component component, File directory, String filename, String extension, boolean isSharingDesired) {
        return FileDialogUtilities.showOpenFileDialog(component, FileUtilities.getCanonicalPathIfPossible(directory), filename, extension, isSharingDesired);
    }

    public static File showSaveFileDialog(Component component, File directory, String filename, String extension, boolean isSharingDesired) {
        return FileDialogUtilities.showSaveFileDialog(component, FileUtilities.getCanonicalPathIfPossible(directory), filename, extension, isSharingDesired);
    }
}

