/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class GraphicsUtilties {
    public static void setRenderingHint(Graphics g, RenderingHints.Key key, Object value) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(key, value);
    }

    public static void drawCenteredText(Graphics g, String s, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        int messageWidth = fm.stringWidth(s);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        g.drawString(s, x + width / 2 - messageWidth / 2, y + height / 2 + ascent / 2 - descent / 2);
    }

    public static void drawCenteredText(Graphics g, String s, Dimension size) {
        GraphicsUtilties.drawCenteredText(g, s, 0, 0, size.width, size.height);
    }

    public static void drawCenteredText(Graphics g, String s, Rectangle rect) {
        GraphicsUtilties.drawCenteredText(g, s, rect.x, rect.y, rect.width, rect.height);
    }

    private static void renderTriangle(Graphics g, Heading heading, int x, int y, int width, int height, boolean isFill) {
        if (heading != null) {
            int[] yPoints;
            int[] xPoints;
            int x0 = x;
            int x1 = x + width - 1;
            int xC = (x0 + x1) / 2;
            int y0 = y;
            int y1 = y + height - 1;
            int yC = (y0 + y1) / 2;
            if (heading == Heading.NORTH) {
                xPoints = new int[]{xC, x1, x0};
                yPoints = new int[]{y0, y1, y1};
            } else if (heading == Heading.EAST) {
                xPoints = new int[]{x1, x0, x0};
                yPoints = new int[]{yC, y1, y0};
            } else if (heading == Heading.SOUTH) {
                xPoints = new int[]{xC, x0, x1};
                yPoints = new int[]{y1, y0, y0};
            } else if (heading == Heading.WEST) {
                xPoints = new int[]{x0, x1, x1};
                yPoints = new int[]{yC, y0, y1};
            } else {
                throw new IllegalArgumentException();
            }
            if (isFill) {
                g.fillPolygon(xPoints, yPoints, 3);
            } else {
                g.drawPolygon(xPoints, yPoints, 3);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void drawTriangle(Graphics g, Heading heading, int x, int y, int width, int height) {
        GraphicsUtilties.renderTriangle(g, heading, x, y, width, height, false);
    }

    public static void drawTriangle(Graphics g, Heading heading, Dimension size) {
        GraphicsUtilties.drawTriangle(g, heading, 0, 0, size.width, size.height);
    }

    public static void drawTriangle(Graphics g, Heading heading, Rectangle rect) {
        GraphicsUtilties.drawTriangle(g, heading, rect.x, rect.y, rect.width, rect.height);
    }

    public static void fillTriangle(Graphics g, Heading heading, int x, int y, int width, int height) {
        GraphicsUtilties.renderTriangle(g, heading, x, y, width, height, true);
    }

    public static void fillTriangle(Graphics g, Heading heading, Dimension size) {
        GraphicsUtilties.fillTriangle(g, heading, 0, 0, size.width, size.height);
    }

    public static void fillTriangle(Graphics g, Heading heading, Rectangle rect) {
        GraphicsUtilties.fillTriangle(g, heading, rect.x, rect.y, rect.width, rect.height);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Heading {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

