/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.awt.BevelState;
import edu.cmu.cs.dennisc.awt.ColorUtilities;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class ShapeUtilties {
    private static GeneralPath s_generalPath = new GeneralPath(1, 2);

    public static void paintBorder(Graphics2D g2, Shape shape, Color a, Color b, int width) {
        int width2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke stroke = g2.getStroke();
        for (int i = width2 = width * 2; i >= 2; i -= 2) {
            float portion = (float)(width2 - i) / (float)width2;
            g2.setColor(ColorUtilities.interpolate(a, b, portion));
            g2.setStroke(new BasicStroke(i));
            g2.draw(shape);
        }
        g2.setStroke(stroke);
    }

    public static void paintBorder(Graphics2D g2, Shape shape, Color a, Color b, int width, int alphaRule) {
        int width2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke stroke = g2.getStroke();
        for (int i = width2 = width * 2; i >= 2; i -= 2) {
            float portion = (float)(width2 - i) / (float)width2;
            g2.setColor(ColorUtilities.interpolate(a, b, portion));
            g2.setComposite(AlphaComposite.getInstance(alphaRule, portion));
            g2.setStroke(new BasicStroke(i));
            g2.draw(shape);
        }
        g2.setStroke(stroke);
    }

    private static void drawShadedLine(Graphics2D g2, float x0, float y0, float x1, float y1, Paint topLeftPaint, Paint otherPaint, Paint bottomRightPaint, GeneralPath buffer) {
        float xDelta = x0 - x1;
        float yDelta = y0 - y1;
        if (xDelta > 0.0f) {
            if (yDelta > 0.0f) {
                g2.setPaint(otherPaint);
            } else if (yDelta < 0.0f) {
                g2.setPaint(topLeftPaint);
            } else {
                g2.setPaint(topLeftPaint);
            }
        } else if (xDelta < 0.0f) {
            if (yDelta > 0.0f) {
                g2.setPaint(bottomRightPaint);
            } else if (yDelta < 0.0f) {
                g2.setPaint(otherPaint);
            } else {
                g2.setPaint(bottomRightPaint);
            }
        } else if (yDelta > 0.0f) {
            g2.setPaint(bottomRightPaint);
        } else if (yDelta < 0.0f) {
            g2.setPaint(topLeftPaint);
        } else {
            return;
        }
        buffer.reset();
        buffer.moveTo(x0, y0);
        buffer.lineTo(x1, y1);
        g2.draw(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paint(Graphics2D g2, Shape shape, BevelState bevelState) {
        g2.fill(shape);
        if (bevelState != null) {
            Paint paintPrev = g2.getPaint();
            if (bevelState == BevelState.FLUSH) {
                g2.setPaint(Color.GRAY);
                g2.draw(shape);
            } else {
                Color bottomRightPaint;
                Color topLeftPaint;
                Stroke strokePrev = g2.getStroke();
                g2.setStroke(new BasicStroke(1.0f, 1, 1));
                float FLATNESS = 0.01f;
                float[] segment = new float[6];
                float x0 = Float.NaN;
                float y0 = Float.NaN;
                float xPrev = Float.NaN;
                float yPrev = Float.NaN;
                Color highlightPaint = new Color(255, 255, 255, 255);
                Color shadowPaint = new Color(0, 0, 0, 255);
                if (bevelState == BevelState.RAISED) {
                    topLeftPaint = highlightPaint;
                    bottomRightPaint = shadowPaint;
                } else {
                    topLeftPaint = shadowPaint;
                    bottomRightPaint = highlightPaint;
                }
                Color inBetweenPaint = new Color(128, 128, 128, 255);
                GeneralPath generalPath = s_generalPath;
                synchronized (generalPath) {
                    PathIterator pathIterator = shape.getPathIterator(null, 0.01f);
                    while (!pathIterator.isDone()) {
                        switch (pathIterator.currentSegment(segment)) {
                            case 0: {
                                x0 = xPrev = segment[0];
                                y0 = yPrev = segment[1];
                                break;
                            }
                            case 1: {
                                float xCurr = segment[0];
                                float yCurr = segment[1];
                                assert (!Float.isNaN(xPrev));
                                assert (!Float.isNaN(yPrev));
                                ShapeUtilties.drawShadedLine(g2, xPrev, yPrev, xCurr, yCurr, topLeftPaint, inBetweenPaint, bottomRightPaint, s_generalPath);
                                xPrev = xCurr;
                                yPrev = yCurr;
                                break;
                            }
                            case 4: {
                                ShapeUtilties.drawShadedLine(g2, xPrev, yPrev, x0, y0, topLeftPaint, inBetweenPaint, bottomRightPaint, s_generalPath);
                                xPrev = Float.NaN;
                                x0 = Float.NaN;
                                yPrev = Float.NaN;
                                y0 = Float.NaN;
                                break;
                            }
                            case 2: {
                                throw new RuntimeException("SEG_QUADTO: should not occur when shape.getPathIterator is passed a flatness argument");
                            }
                            case 3: {
                                throw new RuntimeException("SEG_CUBICTO: should not occur when shape.getPathIterator is passed a flatness argument");
                            }
                            default: {
                                throw new RuntimeException("unhandled segment: should not occur");
                            }
                        }
                        pathIterator.next();
                    }
                }
                g2.setStroke(strokePrev);
            }
            g2.setPaint(paintPrev);
        }
    }
}

