/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt.geom;

import edu.cmu.cs.dennisc.awt.geom.GraphicsContext;
import edu.cmu.cs.dennisc.awt.geom.TransformContext;
import edu.cmu.cs.dennisc.awt.geom.Transformable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Area;

public abstract class Shape
extends Transformable {
    private Paint m_fillPaint = Color.WHITE;
    private Paint m_drawPaint = Color.BLACK;
    private boolean m_isFilled = true;
    private boolean m_isDrawn = true;

    public boolean isFilled() {
        return this.m_isFilled;
    }

    public void setFilled(boolean isFilled) {
        this.m_isFilled = isFilled;
    }

    public boolean isDrawn() {
        return this.m_isDrawn;
    }

    public void setDrawn(boolean isDrawn) {
        this.m_isDrawn = isDrawn;
    }

    public Paint getDrawPaint() {
        return this.m_drawPaint;
    }

    public void setDrawPaint(Paint drawPaint) {
        this.m_drawPaint = drawPaint;
    }

    public Paint getFillPaint() {
        return this.m_fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.m_fillPaint = fillPaint;
    }

    protected abstract java.awt.Shape getFillShape();

    protected abstract java.awt.Shape getDrawShape();

    protected void paintComponent(GraphicsContext gc) {
        java.awt.Shape drawShape;
        java.awt.Shape fillShape;
        Graphics2D g2 = gc.getAWTGraphics2D();
        if (this.isFilled() && (fillShape = this.getFillShape()) != null) {
            g2.setPaint(this.m_fillPaint);
            g2.fill(fillShape);
        }
        if (this.isDrawn() && (drawShape = this.getDrawShape()) != null) {
            g2.setPaint(this.m_drawPaint);
            g2.draw(drawShape);
        }
    }

    protected Area update(Area rv, TransformContext tc) {
        java.awt.Shape fillShape;
        if (this.isFilled() && (fillShape = this.getFillShape()) != null) {
            Area area = new Area(fillShape);
            area.transform(tc.getAffineTransform());
            rv.add(area);
        }
        return rv;
    }
}

