/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt.geom;

import edu.cmu.cs.dennisc.awt.geom.GraphicsContext;
import edu.cmu.cs.dennisc.awt.geom.TransformContext;
import edu.cmu.cs.dennisc.math.Angle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;

public abstract class Transformable {
    private AffineTransform m_affineTransform = new AffineTransform();
    private AffineTransform m_inverseAffineTransform = null;

    public AffineTransform getInverseAffineTransform(AffineTransform rv) {
        if (this.m_inverseAffineTransform == null) {
            try {
                this.m_inverseAffineTransform = this.m_affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException nte) {
                throw new RuntimeException(nte);
            }
        }
        rv.setTransform(this.m_inverseAffineTransform);
        return rv;
    }

    public AffineTransform getInverseAffineTransform() {
        return this.getInverseAffineTransform(new AffineTransform());
    }

    public AffineTransform getAffineTransform(AffineTransform rv) {
        rv.setTransform(this.m_affineTransform);
        return rv;
    }

    public AffineTransform getAffineTransform() {
        return this.getAffineTransform(new AffineTransform());
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.m_affineTransform.setTransform(affineTransform);
        this.m_inverseAffineTransform = null;
    }

    public void applyTranslation(double x, double y) {
        this.m_affineTransform.translate(x, y);
        this.m_inverseAffineTransform = null;
    }

    public void applyRotation(Angle theta) {
        this.m_affineTransform.rotate(theta.getAsRadians());
        this.m_inverseAffineTransform = null;
    }

    public void applyScale(double x, double y) {
        this.m_affineTransform.scale(x, y);
        this.m_inverseAffineTransform = null;
    }

    protected abstract void paintComponent(GraphicsContext var1);

    public final void paint(GraphicsContext gc) {
        gc.pushAffineTransform();
        gc.multiplyAffineTransform(this.m_affineTransform);
        this.paintComponent(gc);
        gc.popAffineTransform();
    }

    protected abstract Area update(Area var1, TransformContext var2);

    public final Area getArea(Area rv, TransformContext tc) {
        tc.pushAffineTransform();
        tc.multiplyAffineTransform(this.m_affineTransform);
        this.update(rv, tc);
        tc.popAffineTransform();
        return rv;
    }

    public final Area getArea(TransformContext tc) {
        return this.getArea(new Area(), tc);
    }
}

