/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.browser;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;

public class BrowserUtilities {
    public static void browse(String url) throws Exception {
        String lcOSName = System.getProperty("os.name").toLowerCase();
        if (lcOSName.startsWith("mac os")) {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else {
            Runtime runtime = Runtime.getRuntime();
            if (lcOSName.startsWith("windows")) {
                runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                Object[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape"};
                boolean found = false;
                for (String string : browsers) {
                    boolean bl = found = runtime.exec(new String[]{"which", string}).waitFor() == 0;
                    if (!found) continue;
                    runtime.exec(new String[]{string, url});
                    break;
                }
                if (!found) {
                    throw new RuntimeException("unable to find browser from amongst: " + Arrays.toString(browsers));
                }
            }
        }
    }

    public static void browse(URI uri) throws Exception {
        BrowserUtilities.browse(uri.getRawPath());
    }

    public static void browse(URL url) throws Exception {
        BrowserUtilities.browse(url.toExternalForm());
    }
}

