/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.cascade;

import edu.cmu.cs.dennisc.cascade.CancelException;
import edu.cmu.cs.dennisc.cascade.FillIn;
import edu.cmu.cs.dennisc.cascade.Node;
import edu.cmu.cs.dennisc.cascade.SeparatorFillIn;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.swing.PopupMenuUtilities;
import edu.cmu.cs.dennisc.task.TaskObserver;
import java.awt.Component;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Blank
extends Node {
    private TaskObserver taskObserver;
    private FillIn selectedFillIn;

    public FillIn getFillInAt(int index) {
        return (FillIn)this.getChildren().get(index);
    }

    public FillIn getParentFillIn() {
        return (FillIn)this.getParent();
    }

    public void addFillIn(FillIn fillIn) {
        super.addChild(fillIn);
    }

    @Override
    protected Blank getNearestBlank() {
        return this;
    }

    @Override
    protected Node getNextNode() {
        return this;
    }

    public FillIn getSelectedFillIn() {
        return this.selectedFillIn;
    }

    public void setSelectedFillIn(FillIn fillIn) {
        this.selectedFillIn = fillIn;
        Node parent = this.getParent();
        if (parent instanceof FillIn) {
            FillIn parentFillIn = (FillIn)parent;
            for (Node child : parent.getChildren()) {
                Blank blank = (Blank)child;
                if (blank.selectedFillIn != null) continue;
                return;
            }
            parentFillIn.select();
        }
    }

    public void addSeparator() {
        this.addSeparator(null);
    }

    public void addSeparator(String text) {
        this.addFillIn(new SeparatorFillIn(text));
    }

    public void showPopupMenu(Component invoker, int x, int y, TaskObserver<? extends Object> taskObserver) {
        this.taskObserver = taskObserver;
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Blank.this.addNextNodeMenuItems(popupMenu);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                popupMenu.removeAll();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                Blank.this.handleCancel(e);
            }
        });
        PopupMenuUtilities.showModal(popupMenu, invoker, x, y);
    }

    protected void handleActionPerformed() {
        try {
            Object value = this.getSelectedFillIn().getValue();
            if (this.taskObserver != null) {
                this.taskObserver.handleCompletion(value);
            } else {
                PrintUtilities.println("handleCompleted (no taskObserver):", this.getSelectedFillIn().getValue());
            }
        }
        catch (CancelException ce) {
            if (this.taskObserver != null) {
                this.taskObserver.handleCancelation();
            }
            PrintUtilities.println("handleCancelation (no taskObserver)");
        }
    }

    protected void handleCancel(PopupMenuEvent e) {
        if (this.taskObserver != null) {
            this.taskObserver.handleCancelation();
        } else {
            PrintUtilities.println("handleCancelation (no taskObserver)");
        }
    }
}

