/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.cascade;

import edu.cmu.cs.dennisc.cascade.Blank;
import edu.cmu.cs.dennisc.cascade.SeparatorFillIn;
import edu.cmu.cs.dennisc.swing.SwingUtilities;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements MenuListener {
    public Node parent = null;
    private Node nextSibling = null;
    private List<Node> children = null;
    private JMenuItem menuItem = null;
    private JComponent menuProxy = null;
    private boolean wasLast = false;
    private ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Node.this.handleActionOperationPerformed();
        }
    };
    private boolean isMenuItemIconUpToDate = false;

    protected void addChild(Node node) {
        if (this.children.size() > 0) {
            Node prevLast = this.children.get(this.children.size() - 1);
            prevLast.nextSibling = node;
        }
        node.parent = this;
        node.nextSibling = null;
        this.children.add(node);
    }

    private void cleanUpUndesiredSeparators() {
        int index;
        ListIterator<Node> listIterator = this.children.listIterator();
        boolean isSeparatorAcceptable = false;
        while (listIterator.hasNext()) {
            Node node = listIterator.next();
            if (node instanceof SeparatorFillIn) {
                if (!isSeparatorAcceptable) {
                    listIterator.remove();
                }
                isSeparatorAcceptable = false;
                continue;
            }
            isSeparatorAcceptable = true;
        }
        int N = this.children.size();
        for (int i = 0; i < N && this.children.get(index = N - i - 1) instanceof SeparatorFillIn; ++i) {
            this.children.remove(index);
        }
    }

    protected abstract void addChildren();

    public List<Node> getChildren() {
        if (this.children == null) {
            this.children = new LinkedList<Node>();
            this.addChildren();
            this.cleanUpUndesiredSeparators();
        }
        return this.children;
    }

    protected Node getNextSibling() {
        return this.nextSibling;
    }

    protected Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    protected boolean isLast() {
        return false;
    }

    protected Blank getRootBlank() {
        if (this.parent != null) {
            return this.parent.getRootBlank();
        }
        return (Blank)this;
    }

    protected JComponent createMenuProxy() {
        return new JLabel("todo: override getMenuProxy");
    }

    protected JComponent getMenuProxy() {
        this.menuProxy = this.createMenuProxy();
        return this.menuProxy;
    }

    protected JComponent getMenuItem() {
        JMenu menu;
        boolean isLast = this.isLast();
        if (this.menuItem != null && this.wasLast != isLast) {
            if (this.menuItem instanceof JMenu) {
                menu = (JMenu)this.menuItem;
                menu.removeMenuListener(this);
            } else {
                this.menuItem.removeActionListener(this.actionListener);
            }
            this.menuItem = null;
        }
        if (this.menuItem == null) {
            if (isLast) {
                this.menuItem = new JMenuItem();
                this.menuItem.addActionListener(this.actionListener);
            } else {
                menu = new JMenu();
                menu.addMenuListener(this);
                this.menuItem = menu;
            }
            this.isMenuItemIconUpToDate = false;
        }
        if (!this.isMenuItemIconUpToDate()) {
            JComponent component = this.getMenuProxy();
            if (component != null) {
                SwingUtilities.invalidateTree(component);
                SwingUtilities.doLayoutTree(component);
                Dimension size = component.getPreferredSize();
                if (size.width > 0 && size.height > 0) {
                    Icon icon = SwingUtilities.createIcon(component);
                    this.menuItem.setIcon(icon);
                    this.menuItem.setText(null);
                } else {
                    this.menuItem.setIcon(null);
                    this.menuItem.setText("unknown");
                }
            } else {
                this.menuItem.setIcon(null);
                this.menuItem.setText("unknown");
            }
            this.setMenuItemIconUpToDate(true);
        }
        return this.menuItem;
    }

    protected boolean isMenuItemIconUpToDate() {
        return this.isMenuItemIconUpToDate;
    }

    protected void setMenuItemIconUpToDate(boolean isMenuItemIconUpToDate) {
        this.isMenuItemIconUpToDate = isMenuItemIconUpToDate;
    }

    protected JMenu getMenu() {
        return (JMenu)this.getMenuItem();
    }

    protected void addNextNodeMenuItems(JComponent parent) {
        for (Node child : this.getNextNode().getChildren()) {
            JComponent menuItem;
            if (child instanceof Blank) {
                child = child.getChildren().get(0);
            }
            if ((menuItem = child.getMenuItem()) != null) {
                parent.add(menuItem);
                continue;
            }
            if (parent instanceof JMenu) {
                JMenu menu = (JMenu)parent;
                menu.addSeparator();
                continue;
            }
            if (!(parent instanceof JPopupMenu)) continue;
            JPopupMenu popupMenu = (JPopupMenu)parent;
            popupMenu.addSeparator();
        }
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.addNextNodeMenuItems(this.menuItem);
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        this.getMenu().removeAll();
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    protected void handleActionOperationPerformed() {
        this.getRootBlank().handleActionPerformed();
    }

    protected Blank getNearestBlank() {
        return this.parent.getNearestBlank();
    }

    protected Blank getNextBlank() {
        Blank blank = this.getNearestBlank();
        if (blank.getNextSibling() != null) {
            return (Blank)blank.getNextSibling();
        }
        if (this.parent != null) {
            return this.parent.getNextBlank();
        }
        return null;
    }

    protected abstract Node getNextNode();
}

