/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.codec;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.ReferenceableBinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinaryDecoder
implements BinaryDecoder {
    private Object createArray(Class<?> componentType) {
        int length = this.decodeInt();
        return Array.newInstance(componentType, length);
    }

    @Override
    public final boolean[] decodeBooleanArray() {
        boolean[] rv = (boolean[])this.createArray(Boolean.TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeBoolean();
        }
        return rv;
    }

    protected abstract byte[] decodeByteArray(byte[] var1);

    @Override
    public final byte[] decodeByteArray() {
        byte[] rv = (byte[])this.createArray(Byte.TYPE);
        return this.decodeByteArray(rv);
    }

    @Override
    public final char[] decodeCharArray() {
        char[] rv = (char[])this.createArray(Character.TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeChar();
        }
        return rv;
    }

    @Override
    public final double[] decodeDoubleArray() {
        double[] rv = (double[])this.createArray(Double.TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeDouble();
        }
        return rv;
    }

    @Override
    public final float[] decodeFloatArray() {
        float[] rv = (float[])this.createArray(Float.TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeFloat();
        }
        return rv;
    }

    @Override
    public final int[] decodeIntArray() {
        int[] rv = (int[])this.createArray(Integer.TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeInt();
        }
        return rv;
    }

    @Override
    public final long[] decodeLongArray() {
        long[] rv = (long[])this.createArray(Long.TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeLong();
        }
        return rv;
    }

    @Override
    public final short[] decodeShortArray() {
        short[] rv = (short[])this.createArray(Short.TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeShort();
        }
        return rv;
    }

    @Override
    public final String[] decodeStringArray() {
        String[] rv = (String[])this.createArray(String.class);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeString();
        }
        return rv;
    }

    @Override
    public final <E extends Enum<E>> E[] decodeEnumArray(Class<E> cls) {
        Enum[] rv = (Enum[])this.createArray(cls);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeEnum(cls);
        }
        return rv;
    }

    @Override
    public final <E extends BinaryEncodableAndDecodable> E[] decodeBinaryEncodableAndDecodableArray(Class<E> cls) {
        BinaryEncodableAndDecodable[] rv = (BinaryEncodableAndDecodable[])this.createArray(cls);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeBinaryEncodableAndDecodable(cls);
        }
        return rv;
    }

    @Override
    public final <E extends ReferenceableBinaryEncodableAndDecodable> E[] decodeReferenceableBinaryEncodableAndDecodableArray(Class<E> cls, Map<Integer, ReferenceableBinaryEncodableAndDecodable> map) {
        ReferenceableBinaryEncodableAndDecodable[] rv = (ReferenceableBinaryEncodableAndDecodable[])this.createArray(cls);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.decodeReferenceableBinaryEncodableAndDecodable(cls, map);
        }
        return rv;
    }

    @Override
    public final <E extends Enum<E>> E decodeEnum(Class<E> cls) {
        boolean isNotNull = this.decodeBoolean();
        if (isNotNull) {
            String clsName = this.decodeString();
            assert (EquivalenceUtilities.areEquivalent(clsName, cls.getName()));
            String name = this.decodeString();
            return Enum.valueOf(cls, name);
        }
        return null;
    }

    @Override
    public final <E extends BinaryEncodableAndDecodable> E decodeBinaryEncodableAndDecodable(Class<E> cls) {
        String clsName = this.decodeString();
        if (clsName.length() > 0) {
            BinaryEncodableAndDecodable rv;
            Class<?> clsActual = ReflectionUtilities.getClassForName(clsName);
            try {
                Constructor<?> cnstrctr = clsActual.getConstructor(BinaryDecoder.class);
                rv = (BinaryEncodableAndDecodable)ReflectionUtilities.newInstance(cnstrctr, this);
            }
            catch (NoSuchMethodException nsme) {
                Constructor<?> cnstrctr = ReflectionUtilities.getConstructor(clsActual, new Class[0]);
                rv = (BinaryEncodableAndDecodable)ReflectionUtilities.newInstance(cnstrctr, new Object[0]);
                rv.decode(this);
            }
            return (E)rv;
        }
        return null;
    }

    @Override
    public final BinaryEncodableAndDecodable decodeBinaryEncodableAndDecodable(BinaryEncodableAndDecodable rv) {
        String clsName = this.decodeString();
        if (rv != null) {
            assert (EquivalenceUtilities.areEquivalent(clsName, rv.getClass().getName()));
            rv.decode(this);
        } else assert (clsName.length() == 0);
        return rv;
    }

    @Override
    public final <E extends ReferenceableBinaryEncodableAndDecodable> E decodeReferenceableBinaryEncodableAndDecodable(Class<E> cls, Map<Integer, ReferenceableBinaryEncodableAndDecodable> map) {
        String clsName = this.decodeString();
        if (clsName.length() > 0) {
            ReferenceableBinaryEncodableAndDecodable rv;
            int reference = this.decodeInt();
            if (map.containsKey(reference)) {
                rv = map.get(reference);
            } else {
                rv = (ReferenceableBinaryEncodableAndDecodable)ReflectionUtilities.newInstance(clsName);
                map.put(reference, rv);
                rv.decode(this, map);
            }
            return (E)rv;
        }
        return null;
    }

    @Override
    public final ReferenceableBinaryEncodableAndDecodable decodeReferenceableBinaryEncodableAndDecodable(ReferenceableBinaryEncodableAndDecodable rv, Map<Integer, ReferenceableBinaryEncodableAndDecodable> map) {
        String clsName = this.decodeString();
        if (rv != null) {
            int reference = this.decodeInt();
            if (map.containsKey(reference)) {
                assert (rv == map.get(reference));
            } else {
                map.put(reference, rv);
                rv.decode(this, map);
            }
        } else assert (clsName.length() == 0);
        return rv;
    }
}

