/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.codec;

import edu.cmu.cs.dennisc.codec.AbstractBinaryDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class InputStreamBinaryDecoder
extends AbstractBinaryDecoder {
    private ObjectInputStream m_ois;

    public InputStreamBinaryDecoder(InputStream is) {
        this.initialize(is);
    }

    public InputStreamBinaryDecoder(File file) {
        try {
            this.initialize(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public InputStreamBinaryDecoder(String path) {
        this(new File(path));
    }

    private void initialize(InputStream is) {
        try {
            this.m_ois = new ObjectInputStream(is);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected byte[] decodeByteArray(byte[] rv) {
        try {
            this.m_ois.readFully(rv);
            return rv;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean decodeBoolean() {
        try {
            return this.m_ois.readBoolean();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public byte decodeByte() {
        try {
            return this.m_ois.readByte();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public char decodeChar() {
        try {
            return this.m_ois.readChar();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public double decodeDouble() {
        try {
            return this.m_ois.readDouble();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public float decodeFloat() {
        try {
            return this.m_ois.readFloat();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public int decodeInt() {
        try {
            return this.m_ois.readInt();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public long decodeLong() {
        try {
            return this.m_ois.readLong();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public short decodeShort() {
        try {
            return this.m_ois.readShort();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String decodeString() {
        try {
            if (this.m_ois.readBoolean()) {
                return this.m_ois.readUTF();
            }
            return null;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

