/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.codec;

import edu.cmu.cs.dennisc.codec.AbstractBinaryEncoder;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class OutputStreamBinaryEncoder
extends AbstractBinaryEncoder {
    private ObjectOutputStream m_oos;

    public OutputStreamBinaryEncoder(OutputStream os) {
        try {
            this.m_oos = new ObjectOutputStream(os);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void encodeBuffer(byte[] buffer) {
        try {
            this.m_oos.write(buffer);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(boolean value) {
        try {
            this.m_oos.writeBoolean(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(byte value) {
        try {
            this.m_oos.writeByte(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(char value) {
        try {
            this.m_oos.writeChar(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(double value) {
        try {
            this.m_oos.writeDouble(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(float value) {
        try {
            this.m_oos.writeFloat(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(int value) {
        try {
            this.m_oos.writeInt(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(long value) {
        try {
            this.m_oos.writeLong(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(short value) {
        try {
            this.m_oos.writeShort(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void encode(String value) {
        try {
            this.m_oos.writeBoolean(value != null);
            this.m_oos.writeUTF(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void flush() {
        try {
            this.m_oos.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

