/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.color;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import java.awt.Color;

public class Color4f
implements BinaryEncodableAndDecodable {
    public static final Color4f BLACK = new Color4f(Color.BLACK);
    public static final Color4f BLUE = new Color4f(Color.BLUE);
    public static final Color4f CYAN = new Color4f(Color.CYAN);
    public static final Color4f DARK_GRAY = new Color4f(Color.DARK_GRAY);
    public static final Color4f GRAY = new Color4f(Color.GRAY);
    public static final Color4f GREEN = new Color4f(Color.GREEN);
    public static final Color4f LIGHT_GRAY = new Color4f(Color.LIGHT_GRAY);
    public static final Color4f MAGENTA = new Color4f(Color.MAGENTA);
    public static final Color4f ORANGE = new Color4f(Color.ORANGE);
    public static final Color4f PINK = new Color4f(Color.PINK);
    public static final Color4f RED = new Color4f(Color.RED);
    public static final Color4f WHITE = new Color4f(Color.WHITE);
    public static final Color4f YELLOW = new Color4f(Color.YELLOW);
    public static final Color4f PURPLE = new Color4f(0.5019608f, 0.0f, 0.5019608f, 1.0f);
    public static final Color4f BROWN = new Color4f(0.63529414f, 0.16470589f, 0.16470589f, 1.0f);
    public float red = 0.0f;
    public float green = 0.0f;
    public float blue = 0.0f;
    public float alpha = 1.0f;

    public Color4f() {
    }

    public Color4f(Color4f other) {
        this.set(other);
    }

    public Color4f(float red, float green, float blue, float alpha) {
        this.set(red, green, blue, alpha);
    }

    public Color4f(Color awtColor) {
        this.set((float)awtColor.getRed() / 255.0f, (float)awtColor.getGreen() / 255.0f, (float)awtColor.getBlue() / 255.0f, (float)awtColor.getAlpha() / 255.0f);
    }

    public static Color4f createNaN() {
        return new Color4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.red = binaryDecoder.decodeFloat();
        this.green = binaryDecoder.decodeFloat();
        this.blue = binaryDecoder.decodeFloat();
        this.alpha = binaryDecoder.decodeFloat();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.red);
        binaryEncoder.encode(this.green);
        binaryEncoder.encode(this.blue);
        binaryEncoder.encode(this.alpha);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Color4f) {
            Color4f color = (Color4f)obj;
            return this.red == color.red && this.green == color.green && this.blue == color.blue && this.alpha == color.alpha;
        }
        return false;
    }

    public boolean isNaN() {
        return Float.isNaN(this.red) || Float.isNaN(this.green) || Float.isNaN(this.blue) || Float.isNaN(this.alpha);
    }

    public void set(Color4f other) {
        if (other != null) {
            this.red = other.red;
            this.green = other.green;
            this.blue = other.blue;
            this.alpha = other.alpha;
        } else {
            this.setNaN();
        }
    }

    public void set(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void setNaN() {
        this.alpha = Float.NaN;
        this.blue = Float.NaN;
        this.green = Float.NaN;
        this.red = Float.NaN;
    }

    public Color getAsAWTColor() {
        if (this.isNaN()) {
            return null;
        }
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    public float[] getAsArray(float[] rv) {
        rv[0] = this.red;
        rv[1] = this.green;
        rv[2] = this.blue;
        rv[3] = this.alpha;
        return rv;
    }

    public float[] getAsArray() {
        return this.getAsArray(new float[4]);
    }

    public void interpolate(Color4f b, float portion) {
        this.red += (b.red - this.red) * portion;
        this.green += (b.green - this.green) * portion;
        this.blue += (b.blue - this.blue) * portion;
        this.alpha += (b.alpha - this.alpha) * portion;
    }

    public void interpolate(Color4f a, Color4f b, float portion) {
        this.red = a.red + (b.red - a.red) * portion;
        this.green = a.green + (b.green - a.green) * portion;
        this.blue = a.blue + (b.blue - a.blue) * portion;
        this.alpha = a.alpha + (b.alpha - a.alpha) * portion;
    }
}

