/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.croquet;

import edu.cmu.cs.dennisc.awt.DimensionUtilties;
import edu.cmu.cs.dennisc.croquet.SuggestiveTextFocusAdapter;
import edu.cmu.cs.dennisc.croquet.SuggestiveTextUtilties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;

public class KSuggestiveTextArea
extends JTextArea {
    private String textForBlankCondition;

    public KSuggestiveTextArea(String text, String textForBlankCondition) {
        super(text);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.textForBlankCondition = textForBlankCondition;
        this.addFocusListener(new SuggestiveTextFocusAdapter(this));
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    e.consume();
                    if (e.isShiftDown()) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public boolean isManagingFocus() {
        return false;
    }

    public Dimension getPreferredSize() {
        return DimensionUtilties.constrainToMinimumHeight(super.getPreferredSize(), 64);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int xDelta = this.getInsets().left;
        g.translate(xDelta, 0);
        SuggestiveTextUtilties.drawBlankTextIfNecessary(this, g, this.textForBlankCondition);
        g.translate(-xDelta, 0);
    }
}

