/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.croquet;

import edu.cmu.cs.dennisc.croquet.SuggestiveTextFocusAdapter;
import edu.cmu.cs.dennisc.croquet.SuggestiveTextUtilties;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JTextField;

public class KSuggestiveTextField
extends JTextField {
    private String textForBlankCondition;

    public KSuggestiveTextField(String text, String textForBlankCondition) {
        super(text);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.textForBlankCondition = textForBlankCondition;
        this.addFocusListener(new SuggestiveTextFocusAdapter(this));
    }

    public Dimension getMaximumSize() {
        Dimension rv = super.getMaximumSize();
        Dimension preferred = this.getPreferredSize();
        rv.height = preferred.height;
        return rv;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        SuggestiveTextUtilties.drawBlankTextIfNecessary(this, g, this.textForBlankCondition);
    }
}

