/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.alice.virtualmachine.event.ResourceContentEvent;
import org.alice.virtualmachine.event.ResourceContentListener;
import org.alice.virtualmachine.resources.ImageResource;

public final class ImageFactory {
    private static Map<ImageResource, BufferedImage> resourceToBufferedImageMap = new HashMap<ImageResource, BufferedImage>();
    private static ResourceContentListener resourceContentListener = new ResourceContentListener(){

        public void contentChanging(ResourceContentEvent e) {
        }

        public void contentChanged(ResourceContentEvent e) {
            ImageFactory.forget((ImageResource)e.getTypedSource());
        }
    };

    private ImageFactory() {
    }

    public static void forget(ImageResource imageResource) {
        resourceToBufferedImageMap.remove(imageResource);
        imageResource.removeContentListener(resourceContentListener);
    }

    public static BufferedImage getBufferedImage(ImageResource imageResource) {
        assert (imageResource != null);
        BufferedImage rv = resourceToBufferedImageMap.get(imageResource);
        if (rv == null) {
            try {
                rv = ImageIO.read(new ByteArrayInputStream(imageResource.getData()));
                imageResource.setWidth(rv.getWidth());
                imageResource.setHeight(rv.getHeight());
                imageResource.addContentListener(resourceContentListener);
                resourceToBufferedImageMap.put(imageResource, rv);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rv;
    }

    public static ImageResource createImageResource(File file) throws IOException {
        String contentType = ImageResource.getContentType(file);
        if (contentType != null) {
            ImageResource rv = new ImageResource(file, contentType);
            ImageFactory.getBufferedImage(rv);
            return rv;
        }
        throw new RuntimeException("content type not found for " + file);
    }
}

