/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.image;

import edu.cmu.cs.dennisc.io.FileUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.swing.filechooser.FileFilter;

public class ImageUtilities {
    public static final String PNG_CODEC_NAME = "png";
    public static final String JPEG_CODEC_NAME = "jpeg";
    public static final String BMP_CODEC_NAME = "bmp";
    public static final String GIF_CODEC_NAME = "gif";
    public static final String TGA_CODEC_NAME = "tga";
    private static final String[] s_codecNames = new String[]{"png", "jpeg", "bmp", "gif", "tga"};
    private static HashMap<String, String[]> s_codecNameToExtensionsMap = null;
    private static HashMap<String, String> s_extensionToCodecNameMap = null;
    private static FileFilter s_fileFilter;
    private static MediaTracker s_mediaTracker;
    private static ImageObserver s_imageObserver;

    public static String[] accessCodecNames() {
        return s_codecNames;
    }

    public static FileFilter accessFileFilter() {
        return s_fileFilter;
    }

    public static boolean isAcceptable(String path) {
        String codecName = ImageUtilities.getCodecNameForExtension(FileUtilities.getExtension(path));
        return codecName != null;
    }

    public static boolean isAcceptable(File file) {
        return ImageUtilities.isAcceptable(file.getName());
    }

    public static String[] getExtensionsForCodecName(String codecName) {
        return s_codecNameToExtensionsMap.get(codecName);
    }

    public static String getCodecNameForExtension(String extension) {
        return s_extensionToCodecNameMap.get(extension.toLowerCase());
    }

    public static BufferedImage read(String path) {
        return ImageUtilities.read(new File(path));
    }

    public static BufferedImage read(String path, ImageReadParam imageReadParam) {
        return ImageUtilities.read(new File(path), imageReadParam);
    }

    public static BufferedImage read(File file) {
        return ImageUtilities.read(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(File file, ImageReadParam imageReadParam) {
        String extension = FileUtilities.getExtension(file);
        String codecName = ImageUtilities.getCodecNameForExtension(extension);
        if (codecName != null) {
            try {
                BufferedImage rv;
                FileInputStream fis = new FileInputStream(file);
                try {
                    rv = ImageUtilities.read(codecName, fis, imageReadParam);
                }
                finally {
                    fis.close();
                }
                return rv;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(FileUtilities.getCanonicalPathIfPossible(file), fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(FileUtilities.getCanonicalPathIfPossible(file), ioe);
            }
            catch (RuntimeException re) {
                PrintUtilities.println(FileUtilities.getCanonicalPathIfPossible(file));
                PrintUtilities.accessPrintStream().flush();
                throw re;
            }
        }
        throw new RuntimeException("Could not find codec for extension: " + extension);
    }

    public static BufferedImage read(URL url) {
        return ImageUtilities.read(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL url, ImageReadParam imageReadParam) {
        String extension = FileUtilities.getExtension(url.getPath());
        String codecName = ImageUtilities.getCodecNameForExtension(extension);
        if (codecName != null) {
            try {
                BufferedImage rv;
                InputStream is = url.openStream();
                try {
                    rv = ImageUtilities.read(codecName, is, imageReadParam);
                }
                finally {
                    is.close();
                }
                return rv;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        throw new RuntimeException("Could not find codec for extension: " + extension);
    }

    public static BufferedImage read(String codecName, InputStream inputStream) {
        return ImageUtilities.read(codecName, inputStream, null);
    }

    private static short getShort(byte[] array, int offset) {
        int low = 0xFF & array[offset + 0];
        int high = 0xFF & array[offset + 1];
        return (short)(low | (high <<= 8));
    }

    private static int getPixel(byte[] array, int offset, int bytesPerPixel) {
        int b;
        int g;
        int r;
        int a = 255;
        if (bytesPerPixel == 1) {
            g = r = 0xFF & array[offset];
            b = r;
        } else {
            if (bytesPerPixel == 2) {
                throw new RuntimeException();
            }
            b = 0xFF & array[offset++];
            g = 0xFF & array[offset++];
            r = 0xFF & array[offset++];
            if (bytesPerPixel == 4) {
                a = 0xFF & array[offset++];
            }
        }
        return (a <<= 24) | (r <<= 16) | (g <<= 8) | (b <<= 0);
    }

    private static BufferedImage readTGA(BufferedInputStream bufferedInputStream) throws IOException {
        BufferedImage bufferedImage;
        int bytesPerPixel;
        boolean isVerticalFlipped;
        byte[] header = new byte[18];
        bufferedInputStream.read(header);
        byte idEntrySize = header[0];
        byte tgaColorMapType = header[1];
        byte tgaImageType = header[2];
        int width = ImageUtilities.getShort(header, 12);
        int height = ImageUtilities.getShort(header, 14);
        byte bitsPerPixel = header[16];
        byte descriptor = header[17];
        int HORIZONTAL_FLIP_MASK = 16;
        int VERTICAL_FLIP_MASK = 32;
        boolean isHorizontalFlipped = (descriptor & 0x10) != 0;
        boolean bl = isVerticalFlipped = (descriptor & 0x20) != 0;
        if (isHorizontalFlipped) {
            throw new RuntimeException("TODO: isHorizontalFlipped");
        }
        if (isVerticalFlipped) {
            throw new RuntimeException("TODO: isVerticalFlipped");
        }
        switch (bitsPerPixel) {
            case 8: {
                bytesPerPixel = 1;
                break;
            }
            case 16: {
                bytesPerPixel = 2;
                break;
            }
            case 24: {
                bytesPerPixel = 3;
                break;
            }
            case 32: {
                bytesPerPixel = 4;
                break;
            }
            default: {
                throw new RuntimeException("TODO: handle bitsPerPixel = " + bitsPerPixel);
            }
        }
        if (tgaColorMapType != 0) {
            throw new RuntimeException("TODO: handle tgaColorMapType = " + tgaColorMapType);
        }
        switch (tgaImageType) {
            case 2: {
                bufferedImage = new BufferedImage(width, height, 2);
                break;
            }
            case 3: {
                if (bytesPerPixel != 1) {
                    throw new RuntimeException("TODO: handle grey image with bytesPerPixel = " + bytesPerPixel);
                }
                bufferedImage = new BufferedImage(width, height, 10);
                break;
            }
            default: {
                throw new RuntimeException("TODO: handle tgaImageType = " + tgaImageType);
            }
        }
        if (idEntrySize > 0) {
            byte[] idEntry = new byte[idEntrySize];
            bufferedInputStream.read(idEntry);
        }
        byte[] pixels = new byte[width * height * bytesPerPixel];
        bufferedInputStream.read(pixels);
        int offset = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = ImageUtilities.getPixel(pixels, offset, bytesPerPixel);
                bufferedImage.setRGB(x, height - 1 - y, pixel);
                offset += bytesPerPixel;
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read(String codecName, InputStream inputStream, ImageReadParam imageReadParam) {
        try {
            BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
            if (codecName.equals(TGA_CODEC_NAME)) {
                return ImageUtilities.readTGA(bufferedInputStream);
            }
            return ImageIO.read(bufferedInputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void write(String path, Image image) {
        ImageUtilities.write(path, image, null);
    }

    public static void write(String path, Image image, ImageReadParam imageWriteParam) {
        ImageUtilities.write(new File(path), image, imageWriteParam);
    }

    public static void write(File file, Image image) {
        ImageUtilities.write(file, image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, Image image, ImageReadParam imageWriteParam) {
        block7: {
            FileUtilities.createParentDirectoriesIfNecessary(file);
            String extension = FileUtilities.getExtension(file);
            String codecName = ImageUtilities.getCodecNameForExtension(extension);
            if (codecName != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        ImageUtilities.write(codecName, fos, image, imageWriteParam);
                        break block7;
                    }
                    finally {
                        fos.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    throw new RuntimeException(fnfe);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            throw new RuntimeException("Could not find codec for extension: " + extension);
        }
    }

    public static void write(String codecName, OutputStream outputStream, Image image) {
        ImageUtilities.write(codecName, outputStream, image, null);
    }

    public static void write(String codecName, OutputStream outputStream, Image image, ImageReadParam imageWriteParam) {
        RenderedImage renderedImage;
        BufferedImage bufferedImage;
        int width = ImageUtilities.getWidth(image);
        int height = ImageUtilities.getHeight(image);
        if (codecName.equals(JPEG_CODEC_NAME)) {
            BufferedImage bufferedImageBGR = null;
            if (image instanceof BufferedImage && (bufferedImage = (BufferedImage)image).getType() == 5) {
                bufferedImageBGR = bufferedImage;
            }
            if (bufferedImageBGR == null) {
                Image originalImage = image;
                bufferedImageBGR = new BufferedImage(width, height, 5);
                Graphics g = image.getGraphics();
                g.drawImage(originalImage, 0, 0, ImageUtilities.accessImageObserver());
                g.dispose();
            }
            image = bufferedImageBGR;
        }
        if (image instanceof RenderedImage) {
            renderedImage = (RenderedImage)((Object)image);
        } else {
            int[] pixels = ImageUtilities.getPixels(image, width, height);
            bufferedImage = new BufferedImage(width, height, 2);
            bufferedImage.setRGB(0, 0, width, height, pixels, 0, width);
            renderedImage = bufferedImage;
        }
        try {
            ImageIO.write(renderedImage, codecName, outputStream);
            outputStream.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static ImageObserver accessImageObserver() {
        return s_imageObserver;
    }

    private static void waitForImage(Image image) {
        s_mediaTracker.addImage(image, 0);
        try {
            s_mediaTracker.waitForID(0);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            s_mediaTracker.removeImage(image);
        }
    }

    public static int getWidth(Image image) {
        ImageUtilities.waitForImage(image);
        return image.getWidth(s_imageObserver);
    }

    public static int getHeight(Image image) {
        ImageUtilities.waitForImage(image);
        return image.getHeight(s_imageObserver);
    }

    public static int[] getPixels(Image image, int width, int height) {
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new RuntimeException("image fetch aborted or errored");
        }
        return pixels;
    }

    public static BufferedImage constructBufferedImage(Image image, int imageType) {
        int width = ImageUtilities.getWidth(image);
        int height = ImageUtilities.getHeight(image);
        BufferedImage bi = new BufferedImage(width, height, imageType);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, ImageUtilities.accessImageObserver());
        g.dispose();
        return bi;
    }

    static {
        String[] pngExtensions = new String[]{PNG_CODEC_NAME};
        String[] jpegExtensions = new String[]{JPEG_CODEC_NAME, "jpg"};
        String[] bmpExtensions = new String[]{BMP_CODEC_NAME};
        String[] gifExtensions = new String[]{GIF_CODEC_NAME};
        String[] tgaExtensions = new String[]{TGA_CODEC_NAME};
        s_codecNameToExtensionsMap = new HashMap();
        s_codecNameToExtensionsMap.put(PNG_CODEC_NAME, pngExtensions);
        s_codecNameToExtensionsMap.put(JPEG_CODEC_NAME, jpegExtensions);
        s_codecNameToExtensionsMap.put(BMP_CODEC_NAME, bmpExtensions);
        s_codecNameToExtensionsMap.put(GIF_CODEC_NAME, gifExtensions);
        s_codecNameToExtensionsMap.put(TGA_CODEC_NAME, tgaExtensions);
        s_extensionToCodecNameMap = new HashMap();
        for (String key : s_codecNameToExtensionsMap.keySet()) {
            String[] value = s_codecNameToExtensionsMap.get(key);
            for (int i = 0; i < value.length; ++i) {
                s_extensionToCodecNameMap.put(value[i], key);
            }
        }
        s_fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || ImageUtilities.isAcceptable(file);
            }

            public String getDescription() {
                StringBuffer sb = new StringBuffer();
                sb.append("Image (");
                for (String key : s_codecNameToExtensionsMap.keySet()) {
                    String[] value = (String[])s_codecNameToExtensionsMap.get(key);
                    for (int i = 0; i < value.length; ++i) {
                        sb.append("*.");
                        sb.append(value[i]);
                        sb.append(";");
                    }
                }
                sb.append(")");
                return sb.toString();
            }
        };
        s_mediaTracker = new MediaTracker(new Panel());
        s_imageObserver = new ImageObserver(){

            public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        };
    }
}

