/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SpringUtilities {
    private SpringUtilities() {
        throw new AssertionError();
    }

    protected static void putConstraint(Container container, Component component, Horizontal horizontal, int x, Vertical vertical, int y) {
        SpringLayout springLayout = (SpringLayout)container.getLayout();
        String horizontalConstraint = horizontal.getInternal();
        String verticalConstraint = vertical.getInternal();
        if (horizontalConstraint != null) {
            springLayout.putConstraint(horizontalConstraint, component, x, horizontalConstraint, (Component)container);
        } else {
            springLayout.putConstraint("West", component, new HorizontalCenterSpring(container, component, x), "West", (Component)container);
        }
        if (verticalConstraint != null) {
            springLayout.putConstraint(verticalConstraint, component, y, verticalConstraint, (Component)container);
        } else {
            springLayout.putConstraint("North", component, new VerticalCenterSpring(container, component, y), "North", (Component)container);
        }
    }

    public static void add(Container container, Component component, Horizontal horizontal, int x, Vertical vertical, int y) {
        SpringUtilities.putConstraint(container, component, horizontal, x, vertical, y);
        container.add(component);
    }

    public static void addNorthEast(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.EAST, -inset, Vertical.NORTH, inset);
    }

    public static void addNorth(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.CENTER, 0, Vertical.NORTH, inset);
    }

    public static void addNorthWest(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.WEST, inset, Vertical.NORTH, inset);
    }

    public static void addEast(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.EAST, -inset, Vertical.CENTER, 0);
    }

    public static void addCenter(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.CENTER, 0, Vertical.CENTER, 0);
    }

    public static void addWest(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.WEST, inset, Vertical.CENTER, 0);
    }

    public static void addSouthEast(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.EAST, -inset, Vertical.SOUTH, -inset);
    }

    public static void addSouth(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.CENTER, 0, Vertical.SOUTH, -inset);
    }

    public static void addSouthWest(Container container, Component component, int inset) {
        SpringUtilities.add(container, component, Horizontal.WEST, inset, Vertical.SOUTH, -inset);
    }

    private static abstract class CenterSpring
    extends Spring {
        private Container container;
        private Component component;
        private int offset;

        public CenterSpring(Container container, Component component, int offset) {
            this.container = container;
            this.component = component;
            this.offset = offset;
        }

        public int getValue() {
            return this.getPreferredValue();
        }

        public void setValue(int value) {
        }

        protected abstract int getValue(Dimension var1);

        public int getPreferredValue() {
            int macro = this.getValue(this.container.getSize());
            Dimension size = this.component.isValid() ? this.component.getSize() : this.component.getPreferredSize();
            int micro = this.getValue(size);
            return this.offset + (macro - micro) / 2;
        }

        public int getMinimumValue() {
            return this.getPreferredValue();
        }

        public int getMaximumValue() {
            return this.getPreferredValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Horizontal {
        WEST("West"),
        CENTER(null),
        EAST("East");

        private String internal;

        private Horizontal(String internal) {
            this.internal = internal;
        }

        public String getInternal() {
            return this.internal;
        }
    }

    private static class HorizontalCenterSpring
    extends CenterSpring {
        public HorizontalCenterSpring(Container container, Component component, int offset) {
            super(container, component, offset);
        }

        protected int getValue(Dimension dimension) {
            return dimension.width;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Vertical {
        NORTH("North"),
        CENTER(null),
        SOUTH("South");

        private String internal;

        private Vertical(String internal) {
            this.internal = internal;
        }

        public String getInternal() {
            return this.internal;
        }
    }

    private static class VerticalCenterSpring
    extends CenterSpring {
        public VerticalCenterSpring(Container container, Component component, int offset) {
            super(container, component, offset);
        }

        protected int getValue(Dimension dimension) {
            return dimension.height;
        }
    }
}

