/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lang;

import edu.cmu.cs.dennisc.lang.StreamHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeUtilities {
    public static int exec(File workingDirectory, Map<String, String> environment, String ... cmds) {
        ProcessBuilder processBuilder = new ProcessBuilder(cmds);
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory);
        }
        if (environment != null) {
            Map<String, String> map = processBuilder.environment();
            for (String key : environment.keySet()) {
                map.put(key, environment.get(key));
            }
        }
        try {
            Process process = processBuilder.start();
            StreamHandler outputHandler = new StreamHandler(process.getInputStream(), System.out);
            StreamHandler errorHandler = new StreamHandler(process.getErrorStream(), System.err);
            outputHandler.start();
            errorHandler.start();
            return process.waitFor();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static int exec(File workingDirectory, String ... cmds) {
        return RuntimeUtilities.exec(workingDirectory, null, cmds);
    }

    public static int exec(String ... cmds) {
        return RuntimeUtilities.exec(null, cmds);
    }
}

