/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lang;

import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemUtilities {
    private static Platform platform;

    public static boolean isPropertyTrue(String propertyName) {
        return "true".equals(System.getProperty(propertyName));
    }

    private static ByteArrayOutputStream getPropertiesAsXMLByteArrayOutputStream() {
        Properties properties = System.getProperties();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            properties.storeToXML(baos, "comment");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return baos;
    }

    public static byte[] getPropertiesAsXMLByteArray() {
        return SystemUtilities.getPropertiesAsXMLByteArrayOutputStream().toByteArray();
    }

    public static String getPropertiesAsXMLString() {
        return SystemUtilities.getPropertiesAsXMLByteArrayOutputStream().toString();
    }

    public static boolean isMac() {
        return platform == Platform.OSX;
    }

    public static boolean isWindows() {
        return platform == Platform.WINDOWS;
    }

    public static <E> E[] returnArray(Class<E> componentType, E ... rv) {
        return rv;
    }

    public static <E> E[] createArray(Class<E> componentType, E[] ... arrays) {
        int n = 0;
        for (E[] array : arrays) {
            if (array == null) continue;
            n += array.length;
        }
        Object[] rv = (Object[])ReflectionUtilities.newArrayInstance(componentType, n);
        int offset = 0;
        for (E[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, rv, offset, array.length);
            offset += array.length;
        }
        return rv;
    }

    static {
        String lowercaseOSName = System.getProperty("os.name").toLowerCase();
        platform = lowercaseOSName.contains("windows") ? Platform.WINDOWS : (lowercaseOSName.startsWith("mac os x") ? Platform.OSX : (lowercaseOSName.startsWith("linux") ? Platform.LINUX : null));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Platform {
        WINDOWS,
        OSX,
        LINUX;

    }
}

