/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lang.reflect;

import edu.cmu.cs.dennisc.lang.ClassUtilities;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtilities {
    private ReflectionUtilities() {
    }

    @Deprecated
    public static Class<?> getClassForName(String className) {
        try {
            return ClassUtilities.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(className, cnfe);
        }
    }

    public static Class<?> getArrayClass(Class<?> componentCls) {
        Object array = Array.newInstance(componentCls, 0);
        return array.getClass();
    }

    public static Class<?> getArrayClass(Class<?> componentCls, int dimensionCount) {
        assert (dimensionCount > 0);
        Class<?> rv = componentCls;
        for (int i = 0; i < dimensionCount; ++i) {
            rv = ReflectionUtilities.getArrayClass(rv);
        }
        return rv;
    }

    public static <T> T newInstance(Constructor<T> cnstrctr, Object ... arguments) {
        try {
            return cnstrctr.newInstance(arguments);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(cnstrctr.toString(), ite);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(cnstrctr.toString(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(cnstrctr.toString(), iae);
        }
    }

    public static <T> T newInstance(Class<T> cls, Class<?>[] parameterClses, Object ... arguments) {
        return ReflectionUtilities.newInstance(ReflectionUtilities.getConstructor(cls, parameterClses), arguments);
    }

    public static <T> T newInstanceForArguments(Class<T> cls, Object ... arguments) {
        return ReflectionUtilities.newInstance(ReflectionUtilities.getConstructorForArguments(cls, arguments), arguments);
    }

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(cls.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(cls.getName(), iae);
        }
    }

    public static Object newInstance(String className) {
        return ReflectionUtilities.newInstance(ReflectionUtilities.getClassForName(className));
    }

    public static Object newArrayInstance(Class<?> componentType, int length) {
        try {
            return Array.newInstance(componentType, length);
        }
        catch (NegativeArraySizeException nase) {
            throw new RuntimeException(nase);
        }
    }

    public static Object newArrayInstance(String componentTypeName, int length) {
        return ReflectionUtilities.newArrayInstance(ReflectionUtilities.getClassForName(componentTypeName), length);
    }

    public static Field getField(Class<?> cls, String name) {
        try {
            return cls.getField(name);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
    }

    public static Field getDeclaredField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        try {
            return cls.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        try {
            return cls.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls, Class<?> ... parameterClses) {
        try {
            return cls.getConstructor(parameterClses);
        }
        catch (NoSuchMethodException nsme) {
            StringBuffer sb = new StringBuffer();
            sb.append(cls.getName());
            for (Class<?> parameterCls : parameterClses) {
                sb.append(" ");
                sb.append(parameterCls.getName());
            }
            throw new RuntimeException(sb.toString(), nsme);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> cls, Class<?> ... parameterClses) {
        try {
            return cls.getDeclaredConstructor(parameterClses);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(cls.getName(), nsme);
        }
    }

    private static <T> Constructor<T> getConstructorForArguments(Constructor<T>[] constructors, Object ... arguments) throws NoSuchMethodException {
        Constructor<T> rv = null;
        for (Constructor<T> constructor : constructors) {
            Class<?>[] parameterClses = constructor.getParameterTypes();
            if (parameterClses.length != arguments.length) continue;
            if (rv != null) {
                throw new RuntimeException("more than one constructor matches arguments");
            }
            rv = constructor;
        }
        if (rv != null) {
            return rv;
        }
        throw new NoSuchMethodException();
    }

    public static <T> Constructor<T> getConstructorForArguments(Class<T> cls, Object ... arguments) {
        try {
            return ReflectionUtilities.getConstructorForArguments(cls.getConstructors(), arguments);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(cls.getName(), nsme);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructorForArguments(Class<T> cls, Object ... arguments) {
        try {
            return ReflectionUtilities.getConstructorForArguments(cls.getDeclaredConstructors(), arguments);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(cls.getName(), nsme);
        }
    }

    public static String getDetail(Object instance, Method method, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("instance=");
        sb.append(instance);
        sb.append(";method=");
        if (method != null) {
            sb.append(method.getName());
        } else {
            sb.append("null");
        }
        sb.append(";args={");
        String separator = " ";
        for (Object arg : args) {
            sb.append(separator);
            sb.append(arg);
            separator = ", ";
        }
        sb.append(" }");
        return sb.toString();
    }

    public static Object invoke(Object instance, Method method, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(ReflectionUtilities.getDetail(instance, method, args), iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ReflectionUtilities.getDetail(instance, method, args), ite);
        }
        catch (RuntimeException re) {
            throw new RuntimeException(ReflectionUtilities.getDetail(instance, method, args), re);
        }
    }

    public static Object get(Field field, Object o) {
        try {
            return field.get(o);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException(iae);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static void set(Field field, Object o, Object value) {
        try {
            field.set(o, value);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException(iae);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private static List<Field> getFields(Class<?> cls, Class<?> clsAssignable, int modifierMask) {
        Field[] fields;
        LinkedList<Field> rv = new LinkedList<Field>();
        for (Field field : fields = cls.getFields()) {
            if (!clsAssignable.isAssignableFrom(field.getType()) || (field.getModifiers() & modifierMask) != modifierMask) continue;
            rv.add(field);
        }
        return rv;
    }

    public static List<Field> getPublicFinalFields(Class<?> cls, Class<?> clsAssignable) {
        return ReflectionUtilities.getFields(cls, clsAssignable, 17);
    }

    public static List<Field> getPublicStaticFinalFields(Class<?> cls, Class<?> clsAssignable) {
        return ReflectionUtilities.getFields(cls, clsAssignable, 25);
    }

    private static <E> List<E> getInstances(Class<?> cls, Class<E> clsAssignable, int modifierMask) {
        Field[] fields;
        LinkedList<Object> rv = new LinkedList<Object>();
        for (Field field : fields = cls.getFields()) {
            if (!clsAssignable.isAssignableFrom(field.getType()) || (field.getModifiers() & modifierMask) != modifierMask) continue;
            Object e = ReflectionUtilities.get(field, null);
            rv.add(e);
        }
        return rv;
    }

    public static <E> List<E> getPublicFinalInstances(Class<?> cls, Class<E> clsAssignable) {
        return ReflectionUtilities.getInstances(cls, clsAssignable, 17);
    }

    public static <E> List<E> getPublicStaticFinalInstances(Class<?> cls, Class<E> clsAssignable) {
        return ReflectionUtilities.getInstances(cls, clsAssignable, 25);
    }

    public static <T> T valueOf(Class<T> cls, String s) {
        Method mthd = ReflectionUtilities.getMethod(cls, "valueOf", String.class);
        return (T)ReflectionUtilities.invoke(null, mthd, s);
    }
}

