/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass;

import edu.cmu.cs.dennisc.lookingglass.LookingGlassFactory;
import java.awt.Container;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class Program
extends edu.cmu.cs.dennisc.program.Program {
    private static LookingGlassFactory s_lookingGlassFactory;
    private boolean m_isReleaseRenderingLockNecessary = false;

    public LookingGlassFactory getLookingGlassFactory() {
        if (s_lookingGlassFactory == null) {
            s_lookingGlassFactory = edu.cmu.cs.dennisc.lookingglass.opengl.LookingGlassFactory.getSingleton();
        }
        return s_lookingGlassFactory;
    }

    private void acquireRenderingLock() {
        s_lookingGlassFactory.acquireRenderingLock();
        this.m_isReleaseRenderingLockNecessary = true;
    }

    private void releaseRenderingLock() {
        if (this.m_isReleaseRenderingLockNecessary) {
            s_lookingGlassFactory.releaseRenderingLock();
        }
    }

    public void invokeLater(Runnable runnable) {
        s_lookingGlassFactory.invokeLater(runnable);
    }

    public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        s_lookingGlassFactory.invokeAndWait(runnable);
    }

    public void invokeAndWait_ThrowRuntimeExceptionsIfNecessary(Runnable runnable) {
        s_lookingGlassFactory.invokeAndWait_ThrowRuntimeExceptionsIfNecessary(runnable);
    }

    protected void preInitialize() {
        this.getLookingGlassFactory();
        this.acquireRenderingLock();
    }

    protected void postInitialize(boolean success) {
        this.releaseRenderingLock();
        if (success) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Container contentPane = Program.this.getContentPane();
                    contentPane.invalidate();
                    contentPane.doLayout();
                }
            });
            s_lookingGlassFactory.incrementAutomaticDisplayCount();
            s_lookingGlassFactory.invokeAndWait_ThrowRuntimeExceptionsIfNecessary(new Runnable(){

                public void run() {
                }
            });
        }
    }

    protected void preRun() {
    }

    protected void postRun() {
    }

    protected boolean handleWindowClosing(WindowEvent e) {
        s_lookingGlassFactory.decrementAutomaticDisplayCount();
        return true;
    }

    protected void handleWindowClosed(WindowEvent e) {
    }
}

