/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.ChangeHandler;
import edu.cmu.cs.dennisc.pattern.AbstractElement;
import edu.cmu.cs.dennisc.pattern.Releasable;
import edu.cmu.cs.dennisc.pattern.event.ReleaseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementAdapter<E extends AbstractElement> {
    protected E m_element;

    public void handleReleased() {
        AdapterFactory.forget(this.m_element);
        ChangeHandler.removeListenersAndObservers(this.m_element);
        this.m_element = null;
    }

    public static void handleReleased(ReleaseEvent e) {
        Releasable releasable = (Releasable)e.getTypedSource();
        if (releasable instanceof AbstractElement) {
            AbstractElement element = (AbstractElement)releasable;
            AbstractElementAdapter<? extends AbstractElement> elementAdapter = AdapterFactory.getAdapterForElement(element);
            if (elementAdapter != null) {
                elementAdapter.handleReleased();
            }
        } else {
            throw new Error("this should never occur");
        }
    }

    public void initialize(E element) {
        this.m_element = element;
    }

    public String toString() {
        if (this.m_element != null) {
            return this.getClass().getName() + " " + this.m_element.toString();
        }
        return super.toString();
    }
}

