/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.PickObserver;
import edu.cmu.cs.dennisc.lookingglass.PickResult;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassDisplayChangeEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassInitializeEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassListener;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassRenderEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassResizeEvent;
import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.FrustumPerspectiveCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.GLEventAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.LookingGlassFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.OrthographicCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.SymmetricPerspectiveCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.TextureAdapter;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.ClippedZPlane;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.pattern.DefaultReleasable;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.FrustumPerspectiveCamera;
import edu.cmu.cs.dennisc.scenegraph.OrthographicCamera;
import edu.cmu.cs.dennisc.scenegraph.SymmetricPerspectiveCamera;
import edu.cmu.cs.dennisc.texture.Texture;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractLookingGlass
extends DefaultReleasable
implements LookingGlass {
    private static Rectangle s_actualViewportBufferForReuse = new Rectangle();
    private static Dimension s_sizeBufferForReuse = new Dimension();
    private GLEventAdapter m_glEventAdapter = new GLEventAdapter(this);
    private String m_description = new String();
    private Vector<AbstractCamera> m_cameras = new Vector();
    private Vector<LookingGlassListener> m_lookingGlassListeners = new Vector();
    private LookingGlassFactory m_lookingGlassFactory;
    private boolean m_isRenderingEnabled = true;

    protected abstract GLAutoDrawable getGLAutoDrawable();

    protected AbstractLookingGlass(LookingGlassFactory lookingGlassFactory) {
        this.m_lookingGlassFactory = lookingGlassFactory;
    }

    @Override
    public edu.cmu.cs.dennisc.lookingglass.LookingGlassFactory getLookingGlassFactory() {
        return this.m_lookingGlassFactory;
    }

    @Override
    public Graphics2D createGraphics(Texture texture) {
        TextureAdapter<? extends Texture> textureAdapter = AdapterFactory.getAdapterFor(texture);
        return textureAdapter.createGraphics();
    }

    @Override
    public void commitGraphics(Texture texture, Graphics2D g, int x, int y, int width, int height) {
        TextureAdapter<? extends Texture> textureAdapter = AdapterFactory.getAdapterFor(texture);
        textureAdapter.commitGraphics(g, x, y, width, height);
    }

    @Override
    public void commitGraphics(Texture sgTexture, Graphics2D g) {
        this.commitGraphics(sgTexture, g, 0, 0, sgTexture.getWidth(), sgTexture.getHeight());
    }

    @Override
    public Image getImage(Texture texture) {
        TextureAdapter<? extends Texture> textureAdapter = AdapterFactory.getAdapterFor(texture);
        return textureAdapter.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireInitialized(LookingGlassInitializeEvent e) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            for (LookingGlassListener lookingGlassListener : this.m_lookingGlassListeners) {
                lookingGlassListener.initialized(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireCleared(LookingGlassRenderEvent e) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            for (LookingGlassListener lookingGlassListener : this.m_lookingGlassListeners) {
                lookingGlassListener.cleared(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRendered(LookingGlassRenderEvent e) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            for (LookingGlassListener lookingGlassListener : this.m_lookingGlassListeners) {
                lookingGlassListener.rendered(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireResized(LookingGlassResizeEvent e) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            for (LookingGlassListener lookingGlassListener : this.m_lookingGlassListeners) {
                lookingGlassListener.resized(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDisplayChanged(LookingGlassDisplayChangeEvent e) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            for (LookingGlassListener lookingGlassListener : this.m_lookingGlassListeners) {
                lookingGlassListener.displayChanged(e);
            }
        }
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCamera(AbstractCamera camera) {
        Vector<AbstractCamera> vector = this.m_cameras;
        synchronized (vector) {
            this.m_cameras.add(camera);
        }
        if (!this.m_glEventAdapter.isListening()) {
            GLAutoDrawable glAutoDrawable = this.getGLAutoDrawable();
            this.m_glEventAdapter.startListening(glAutoDrawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCamera(AbstractCamera camera) {
        Vector<AbstractCamera> vector = this.m_cameras;
        synchronized (vector) {
            this.m_cameras.remove(camera);
        }
        if (this.m_glEventAdapter.isListening() && this.m_cameras.isEmpty()) {
            this.m_glEventAdapter.stopListening(this.getGLAutoDrawable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCameras() {
        Vector<AbstractCamera> vector = this.m_cameras;
        synchronized (vector) {
            this.m_cameras.clear();
        }
        if (this.m_glEventAdapter.isListening()) {
            this.m_glEventAdapter.stopListening(this.getGLAutoDrawable());
        }
    }

    @Override
    public int getCameraCount() {
        return this.m_cameras.size();
    }

    @Override
    public AbstractCamera getCameraAt(int index) {
        return this.m_cameras.elementAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractCamera[] getCameras(AbstractCamera[] rv) {
        Vector<AbstractCamera> vector = this.m_cameras;
        synchronized (vector) {
            this.m_cameras.copyInto(rv);
        }
        return rv;
    }

    @Override
    public AbstractCamera[] getCameras() {
        AbstractCamera[] rv = new AbstractCamera[this.getCameraCount()];
        return this.getCameras(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<AbstractCamera> accessCameras() {
        Vector<AbstractCamera> vector = this.m_cameras;
        synchronized (vector) {
            return this.m_cameras;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractCamera getCameraAtPixel(int xPixel, int yPixel) {
        Vector<AbstractCamera> vector = this.m_cameras;
        synchronized (vector) {
            for (int i = this.m_cameras.size() - 1; i >= 0; --i) {
                AbstractCamera sgCameraI = this.m_cameras.elementAt(i);
                Rectangle rectangle = s_actualViewportBufferForReuse;
                synchronized (rectangle) {
                    this.getActualViewport(s_actualViewportBufferForReuse, sgCameraI);
                    if (s_actualViewportBufferForReuse.contains(xPixel, yPixel)) {
                        return sgCameraI;
                    }
                    continue;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookingGlassListener(LookingGlassListener lookingGlassListener) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            this.m_lookingGlassListeners.add(lookingGlassListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLookingGlassListener(LookingGlassListener lookingGlassListener) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            this.m_lookingGlassListeners.remove(lookingGlassListener);
        }
    }

    @Override
    public int getLookingGlassListenerCount() {
        return this.m_lookingGlassListeners.size();
    }

    @Override
    public LookingGlassListener getLookingGlassListenerAt(int index) {
        return this.m_lookingGlassListeners.elementAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookingGlassListener[] getLookingGlassListeners(LookingGlassListener[] rv) {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            this.m_lookingGlassListeners.copyInto(rv);
        }
        return rv;
    }

    @Override
    public LookingGlassListener[] getLookingGlassListeners() {
        LookingGlassListener[] rv = new LookingGlassListener[this.getLookingGlassListenerCount()];
        return this.getLookingGlassListeners(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<LookingGlassListener> accessLookingGlassListeners() {
        Vector<LookingGlassListener> vector = this.m_lookingGlassListeners;
        synchronized (vector) {
            return this.m_lookingGlassListeners;
        }
    }

    @Override
    public final Dimension getSize() {
        return this.getSize(new Dimension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getWidth() {
        Dimension dimension = s_sizeBufferForReuse;
        synchronized (dimension) {
            this.getSize(s_sizeBufferForReuse);
            return AbstractLookingGlass.s_sizeBufferForReuse.width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getHeight() {
        Dimension dimension = s_sizeBufferForReuse;
        synchronized (dimension) {
            this.getSize(s_sizeBufferForReuse);
            return AbstractLookingGlass.s_sizeBufferForReuse.height;
        }
    }

    @Override
    public Rectangle getSpecifiedViewport(AbstractCamera camera) {
        AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter = AdapterFactory.getAdapterFor(camera);
        return cameraAdapter.getSpecifiedViewport();
    }

    @Override
    public void setSpecifiedViewport(Rectangle viewport, AbstractCamera camera) {
        AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter = AdapterFactory.getAdapterFor(camera);
        cameraAdapter.setSpecifiedViewport(viewport);
    }

    public Rectangle getActualViewport(Rectangle rv, AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter) {
        return cameraAdapter.getActualViewport(rv, this.getWidth(), this.getHeight());
    }

    @Override
    public Rectangle getActualViewport(Rectangle rv, AbstractCamera camera) {
        return this.getActualViewport(rv, AdapterFactory.getAdapterFor(camera));
    }

    @Override
    public final Rectangle getActualViewport(AbstractCamera camera) {
        return this.getActualViewport(new Rectangle(), camera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Matrix4x4 getActualProjectionMatrix(Matrix4x4 rv, AbstractCamera camera) {
        Rectangle rectangle = s_actualViewportBufferForReuse;
        synchronized (rectangle) {
            AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter = AdapterFactory.getAdapterFor(camera);
            this.getActualViewport(s_actualViewportBufferForReuse, cameraAdapter);
            return cameraAdapter.getActualProjectionMatrix(rv, s_actualViewportBufferForReuse);
        }
    }

    @Override
    public final Matrix4x4 getActualProjectionMatrix(AbstractCamera camera) {
        return this.getActualProjectionMatrix(new Matrix4x4(), camera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClippedZPlane getActualPicturePlane(ClippedZPlane rv, OrthographicCamera orthographicCamera) {
        Rectangle rectangle = s_actualViewportBufferForReuse;
        synchronized (rectangle) {
            OrthographicCameraAdapter orthographicCameraAdapter = AdapterFactory.getAdapterFor(orthographicCamera);
            this.getActualViewport(s_actualViewportBufferForReuse, orthographicCameraAdapter);
            return orthographicCameraAdapter.getActualPicturePlane(rv, s_actualViewportBufferForReuse);
        }
    }

    @Override
    public final ClippedZPlane getActualPicturePlane(OrthographicCamera orthographicCamera) {
        return this.getActualPicturePlane(new ClippedZPlane(), orthographicCamera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClippedZPlane getActualPicturePlane(ClippedZPlane rv, FrustumPerspectiveCamera frustumPerspectiveCamera) {
        Rectangle rectangle = s_actualViewportBufferForReuse;
        synchronized (rectangle) {
            FrustumPerspectiveCameraAdapter frustumPerspectiveCameraAdapter = AdapterFactory.getAdapterFor(frustumPerspectiveCamera);
            this.getActualViewport(s_actualViewportBufferForReuse, frustumPerspectiveCameraAdapter);
            return frustumPerspectiveCameraAdapter.getActualPicturePlane(rv, s_actualViewportBufferForReuse);
        }
    }

    @Override
    public final ClippedZPlane getActualPicturePlane(FrustumPerspectiveCamera frustumPerspectiveCamera) {
        return this.getActualPicturePlane(new ClippedZPlane(), frustumPerspectiveCamera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Angle getActualHorizontalViewingAngle(SymmetricPerspectiveCamera symmetricPerspectiveCamera) {
        Rectangle rectangle = s_actualViewportBufferForReuse;
        synchronized (rectangle) {
            SymmetricPerspectiveCameraAdapter symmetricPerspectiveCameraAdapter = AdapterFactory.getAdapterFor(symmetricPerspectiveCamera);
            this.getActualViewport(s_actualViewportBufferForReuse, symmetricPerspectiveCameraAdapter);
            return symmetricPerspectiveCameraAdapter.getActualHorizontalViewingAngle(s_actualViewportBufferForReuse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Angle getActualVerticalViewingAngle(SymmetricPerspectiveCamera symmetricPerspectiveCamera) {
        Rectangle rectangle = s_actualViewportBufferForReuse;
        synchronized (rectangle) {
            SymmetricPerspectiveCameraAdapter symmetricPerspectiveCameraAdapter = AdapterFactory.getAdapterFor(symmetricPerspectiveCamera);
            this.getActualViewport(s_actualViewportBufferForReuse, symmetricPerspectiveCameraAdapter);
            return symmetricPerspectiveCameraAdapter.getActualVerticalViewingAngle(s_actualViewportBufferForReuse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ray getRayAtPixel(Ray rv, int xPixel, int yPixel, AbstractCamera sgCamera) {
        if (sgCamera != null) {
            Rectangle rectangle = s_actualViewportBufferForReuse;
            synchronized (rectangle) {
                AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter = AdapterFactory.getAdapterFor(sgCamera);
                this.getActualViewport(s_actualViewportBufferForReuse, cameraAdapter);
                cameraAdapter.getRayAtPixel(rv, xPixel, yPixel, s_actualViewportBufferForReuse);
            }
        } else {
            rv.setNaN();
        }
        return rv;
    }

    @Override
    public final Ray getRayAtPixel(int xPixel, int yPixel, AbstractCamera sgCamera) {
        return this.getRayAtPixel(new Ray(), xPixel, yPixel, sgCamera);
    }

    @Override
    public Ray getRayAtPixel(Ray rv, int xPixel, int yPixel) {
        return this.getRayAtPixel(rv, xPixel, yPixel, this.getCameraAtPixel(xPixel, yPixel));
    }

    @Override
    public final Ray getRayAtPixel(int xPixel, int yPixel) {
        return this.getRayAtPixel(new Ray(), xPixel, yPixel);
    }

    @Override
    public boolean isLetterboxedAsOpposedToDistorted(AbstractCamera camera) {
        AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter = AdapterFactory.getAdapterFor(camera);
        return cameraAdapter.isLetterboxedAsOpposedToDistorted();
    }

    @Override
    public void setIsLetterboxedAsOpposedToDistorted(boolean isLetterboxedAsOpposedToDistorted, AbstractCamera camera) {
        AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter = AdapterFactory.getAdapterFor(camera);
        cameraAdapter.setIsLetterboxedAsOpposedToDistorted(isLetterboxedAsOpposedToDistorted);
    }

    @Override
    public BufferedImage createBufferedImageForUseAsColorBuffer() {
        return this.m_glEventAdapter.createBufferedImageForUseAsColorBuffer();
    }

    @Override
    public BufferedImage getColorBuffer(BufferedImage rv) {
        return this.m_glEventAdapter.getColorBuffer(rv);
    }

    @Override
    public final BufferedImage getColorBuffer() {
        return this.getColorBuffer(this.createBufferedImageForUseAsColorBuffer());
    }

    @Override
    public BufferedImage createBufferedImageForUseAsColorBufferWithTransparencyBasedOnDepthBuffer() {
        return this.m_glEventAdapter.createBufferedImageForUseAsColorBufferWithTransparencyBasedOnDepthBuffer();
    }

    @Override
    public FloatBuffer createFloatBufferForUseAsDepthBuffer() {
        return this.m_glEventAdapter.createFloatBufferForUseAsDepthBuffer();
    }

    @Override
    public FloatBuffer getDepthBuffer(FloatBuffer rv) {
        return this.m_glEventAdapter.getDepthBuffer(rv);
    }

    @Override
    public final FloatBuffer getDepthBuffer() {
        return this.getDepthBuffer(this.createFloatBufferForUseAsDepthBuffer());
    }

    @Override
    public BufferedImage getColorBufferWithTransparencyBasedOnDepthBuffer(BufferedImage rv, FloatBuffer depthBuffer) {
        return this.m_glEventAdapter.getColorBufferWithTransparencyBasedOnDepthBuffer(rv, depthBuffer);
    }

    @Override
    public final BufferedImage getColorBufferWithTransparencyBasedOnDepthBuffer() {
        return this.getColorBufferWithTransparencyBasedOnDepthBuffer(this.createBufferedImageForUseAsColorBufferWithTransparencyBasedOnDepthBuffer(), this.createFloatBufferForUseAsDepthBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PickResult pickFrontMost(int xPixel, int yPixel, boolean isSubElementRequired, PickObserver pickObserver) {
        PickResult rv;
        GLCapabilities glCapabilities = this.getGLAutoDrawable().getChosenGLCapabilities();
        AbstractCamera sgCamera = this.getCameraAtPixel(xPixel, yPixel);
        if (sgCamera != null) {
            this.m_lookingGlassFactory.acquireRenderingLock();
            try {
                rv = this.m_glEventAdapter.pickFrontMost(sgCamera, xPixel, yPixel, isSubElementRequired, pickObserver);
            }
            finally {
                this.m_lookingGlassFactory.releaseRenderingLock();
            }
        } else {
            rv = new PickResult();
            rv.setNaN();
        }
        return rv;
    }

    @Override
    public PickResult pickFrontMost(int xPixel, int yPixel, boolean isSubElementRequired) {
        return this.pickFrontMost(xPixel, yPixel, isSubElementRequired, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PickResult> pickAll(int xPixel, int yPixel, boolean isSubElementRequired, PickObserver pickObserver) {
        AbstractCamera sgCamera = this.getCameraAtPixel(xPixel, yPixel);
        if (sgCamera != null) {
            this.m_lookingGlassFactory.acquireRenderingLock();
            try {
                List<PickResult> list = this.m_glEventAdapter.pickAll(sgCamera, xPixel, yPixel, isSubElementRequired, pickObserver);
                return list;
            }
            finally {
                this.m_lookingGlassFactory.releaseRenderingLock();
            }
        }
        return new LinkedList<PickResult>();
    }

    @Override
    public List<PickResult> pickAll(int xPixel, int yPixel, boolean isSubElementRequired) {
        return this.pickAll(xPixel, yPixel, isSubElementRequired, null);
    }

    public double[] getActualPlane(double[] rv, Dimension size, OrthographicCamera orthographicCamera) {
        throw new RuntimeException("todo");
    }

    public double[] getActualPlane(double[] rv, Dimension size, FrustumPerspectiveCamera perspectiveCamera) {
        throw new RuntimeException("todo");
    }

    @Override
    public boolean isRenderingEnabled() {
        return this.m_isRenderingEnabled;
    }

    protected abstract void repaintIfAppropriate();

    @Override
    public void setRenderingEnabled(boolean isRenderingEnabled) {
        if (this.m_isRenderingEnabled != isRenderingEnabled) {
            this.m_isRenderingEnabled = isRenderingEnabled;
            this.repaintIfAppropriate();
        }
    }
}

