/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lang.ThreadUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;

abstract class Animator
implements Runnable {
    public static final long DEFAULT_SLEEP_MILLIS = 5L;
    private boolean isActive = false;
    private long tStart;
    private int frameCount;
    private long sleepMillis = 5L;

    Animator() {
    }

    public void start() {
        this.isActive = true;
        this.frameCount = 0;
        this.tStart = System.currentTimeMillis();
        new Thread(this).start();
    }

    public void stop() {
        this.isActive = false;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public long getStartTimeMillis() {
        return this.tStart;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public void setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
    }

    protected abstract ThreadDeferenceAction step();

    public void run() {
        long THRESHOLD = 5L;
        long tPrev = System.currentTimeMillis() - 5L;
        while (this.isActive) {
            long tCurrent;
            while ((tCurrent = System.currentTimeMillis()) - tPrev < 5L) {
                ThreadUtilities.sleep(5L);
            }
            tPrev = tCurrent;
            ThreadDeferenceAction threadAction = this.step();
            if (threadAction == ThreadDeferenceAction.SLEEP) {
                ThreadUtilities.sleep(this.sleepMillis);
            } else if (threadAction == ThreadDeferenceAction.YIELD) {
                Thread.yield();
            } else {
                PrintUtilities.println(new Object[]{"threadAction", threadAction});
            }
            ++this.frameCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThreadDeferenceAction {
        DO_NOTHING,
        SLEEP,
        YIELD;

    }
}

