/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.ComponentAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.CompositeAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.ElementAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.LayerAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.TextureAdapter;
import edu.cmu.cs.dennisc.pattern.AbstractElement;
import edu.cmu.cs.dennisc.pattern.event.Event;
import edu.cmu.cs.dennisc.pattern.event.ReleaseEvent;
import edu.cmu.cs.dennisc.pattern.event.ReleaseListener;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.property.event.PropertyEvent;
import edu.cmu.cs.dennisc.property.event.PropertyListener;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.Layer;
import edu.cmu.cs.dennisc.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.dennisc.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.dennisc.scenegraph.event.ComponentAddedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.ComponentRemovedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.ComponentsListener;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicAddedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicRemovedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicsListener;
import edu.cmu.cs.dennisc.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.dennisc.scenegraph.event.HierarchyListener;
import edu.cmu.cs.dennisc.texture.Texture;
import edu.cmu.cs.dennisc.texture.event.TextureEvent;
import edu.cmu.cs.dennisc.texture.event.TextureListener;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeHandler {
    private static List<Event<?>> s_events = new LinkedList();
    private static Object s_object = new Object();
    private static int s_count;
    private static int eventCount;
    private static PropertyListener s_propertyListener;
    private static ComponentsListener s_childrenListener;
    private static GraphicsListener s_graphicsListener;
    private static AbsoluteTransformationListener s_absoluteTransformationListener;
    private static HierarchyListener s_hierarchyListener;
    private static TextureListener s_textureListener;
    private static ReleaseListener s_releaseListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushRenderingMode() {
        Object object = s_object;
        synchronized (object) {
            --s_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popRenderingMode() {
        if (s_count == -1) {
            Object object = s_object;
            synchronized (object) {
                ChangeHandler.handleBufferedChanges();
                ++s_count;
            }
        }
    }

    private static boolean isInRenderingMode() {
        return false;
    }

    public static int getEventCountSinceLastReset() {
        return eventCount;
    }

    public static void resetEventCount() {
        eventCount = 0;
    }

    private static void handleEvent(Event<?> event) {
        if (event instanceof PropertyEvent) {
            PropertyEvent propertyEvent = (PropertyEvent)event;
            ElementAdapter.handlePropertyChanged((InstanceProperty)propertyEvent.getTypedSource());
        } else if (event instanceof ReleaseEvent) {
            ElementAdapter.handleReleased((ReleaseEvent)event);
        } else if (event instanceof AbsoluteTransformationEvent) {
            AbsoluteTransformationEvent absoluteTransformationEvent = (AbsoluteTransformationEvent)event;
            ComponentAdapter.handleAbsoluteTransformationChanged((Component)absoluteTransformationEvent.getTypedSource());
        } else if (event instanceof HierarchyEvent) {
            ComponentAdapter.handleHierarchyChanged((HierarchyEvent)event);
        } else if (event instanceof ComponentAddedEvent) {
            CompositeAdapter.handleComponentAdded((ComponentAddedEvent)event);
        } else if (event instanceof ComponentRemovedEvent) {
            CompositeAdapter.handleComponentRemoved((ComponentRemovedEvent)event);
        } else if (event instanceof GraphicAddedEvent) {
            LayerAdapter.handleGraphicAdded((GraphicAddedEvent)event);
        } else if (event instanceof GraphicRemovedEvent) {
            LayerAdapter.handleGraphicRemoved((GraphicRemovedEvent)event);
        } else if (event instanceof TextureEvent) {
            TextureAdapter.handleTextureChanged((TextureEvent)event);
        } else {
            System.err.println("UNHANDLED EVENT: " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleOrBufferEvent(Event<?> event) {
        if (ChangeHandler.isInRenderingMode()) {
            List<Event<?>> list = s_events;
            synchronized (list) {
                s_events.add(event);
            }
        }
        Object object = s_object;
        synchronized (object) {
            ChangeHandler.handleEvent(event);
        }
        ++eventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleBufferedChanges() {
        List<Event<?>> list = s_events;
        synchronized (list) {
            for (Event<?> event : s_events) {
                ChangeHandler.handleEvent(event);
            }
        }
    }

    public static void addListenersAndObservers(AbstractElement element) {
        element.addReleaseListener(s_releaseListener);
        if (element instanceof Element) {
            ((Element)element).addPropertyListener(s_propertyListener);
            if (element instanceof Component) {
                ((Component)element).addAbsoluteTransformationListener(s_absoluteTransformationListener);
                ((Component)element).addHierarchyListener(s_hierarchyListener);
                if (element instanceof Composite) {
                    ((Composite)element).addChildrenListener(s_childrenListener);
                }
            } else if (element instanceof Layer) {
                ((Layer)element).addGraphicsListener(s_graphicsListener);
            }
        } else if (element instanceof Texture) {
            ((Texture)element).addTextureListener(s_textureListener);
        }
    }

    public static void removeListenersAndObservers(AbstractElement element) {
        element.removeReleaseListener(s_releaseListener);
        if (element instanceof Element) {
            ((Element)element).removePropertyListener(s_propertyListener);
            if (element instanceof Component) {
                ((Component)element).removeAbsoluteTransformationListener(s_absoluteTransformationListener);
                ((Component)element).removeHierarchyListener(s_hierarchyListener);
                if (element instanceof Composite) {
                    ((Composite)element).removeChildrenListener(s_childrenListener);
                }
            } else if (element instanceof Layer) {
                ((Layer)element).removeGraphicsListener(s_graphicsListener);
            }
        } else if (element instanceof Texture) {
            ((Texture)element).removeTextureListener(s_textureListener);
        }
    }

    static {
        eventCount = 0;
        s_propertyListener = new PropertyListener(){

            public void propertyChanging(PropertyEvent e) {
            }

            public void propertyChanged(PropertyEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }
        };
        s_childrenListener = new ComponentsListener(){

            public void componentAdded(ComponentAddedEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }

            public void componentRemoved(ComponentRemovedEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }
        };
        s_graphicsListener = new GraphicsListener(){

            public void graphicAdded(GraphicAddedEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }

            public void graphicRemoved(GraphicRemovedEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }
        };
        s_absoluteTransformationListener = new AbsoluteTransformationListener(){

            public void absoluteTransformationChanged(AbsoluteTransformationEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }
        };
        s_hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }
        };
        s_textureListener = new TextureListener(){

            public void textureChanged(TextureEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }
        };
        s_releaseListener = new ReleaseListener(){

            public void releasing(ReleaseEvent e) {
            }

            public void released(ReleaseEvent e) {
                ChangeHandler.handleOrBufferEvent(e);
            }
        };
    }
}

