/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.ConformanceTestResults;
import edu.cmu.cs.dennisc.lookingglass.opengl.ElementAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.GhostAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickParameters;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.SceneAdapter;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.pattern.Visitable;
import edu.cmu.cs.dennisc.pattern.Visitor;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Scene;
import edu.cmu.cs.dennisc.scenegraph.event.HierarchyEvent;
import java.nio.DoubleBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentAdapter<E extends Component>
extends ElementAdapter<E>
implements Visitable {
    private static AffineMatrix4x4 s_buffer = AffineMatrix4x4.createNaN();
    private double[] m_absolute = new double[16];
    private double[] m_inverseAbsolute = new double[16];
    private DoubleBuffer m_absoluteBuffer = DoubleBuffer.wrap(this.m_absolute);
    private DoubleBuffer m_inverseAbsoluteBuffer = DoubleBuffer.wrap(this.m_inverseAbsolute);
    private SceneAdapter m_sceneAdapter = null;

    protected ComponentAdapter() {
        this.handleAbsoluteTransformationChanged();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAbsoluteTransformationChanged() {
        double[] dArray = this.m_absolute;
        synchronized (this.m_absolute) {
            this.m_absolute[0] = Double.NaN;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            dArray = this.m_inverseAbsolute;
            synchronized (this.m_inverseAbsolute) {
                this.m_inverseAbsolute[0] = Double.NaN;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    protected void handleHierarchyChanged() {
        Composite sgRoot = ((Component)this.m_element).getRoot();
        SceneAdapter sceneAdapter = sgRoot instanceof Scene ? AdapterFactory.getAdapterFor((Scene)sgRoot) : null;
        if (this.m_sceneAdapter != sceneAdapter) {
            if (this.m_sceneAdapter != null) {
                this.m_sceneAdapter.removeDescendant(this);
            }
            this.m_sceneAdapter = sceneAdapter;
            if (this.m_sceneAdapter != null) {
                this.m_sceneAdapter.addDescendant(this);
            }
        }
    }

    public static void handleAbsoluteTransformationChanged(Component component) {
        ComponentAdapter<? extends Component> componentAdapter = AdapterFactory.getAdapterFor(component);
        componentAdapter.handleAbsoluteTransformationChanged();
    }

    public static void handleHierarchyChanged(HierarchyEvent e) {
        ComponentAdapter<? extends Component> componentAdapter = AdapterFactory.getAdapterFor((Component)e.getTypedSource());
        componentAdapter.handleHierarchyChanged();
    }

    public SceneAdapter getSceneAdapter() {
        Composite sgRoot = ((Component)this.m_element).getRoot();
        if (sgRoot instanceof Scene) {
            return AdapterFactory.getAdapterFor((Scene)sgRoot);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAbsoluteTransformationIfNecessary() {
        AffineMatrix4x4 affineMatrix4x4 = s_buffer;
        synchronized (affineMatrix4x4) {
            double[] dArray = this.m_absolute;
            synchronized (this.m_absolute) {
                if (Double.isNaN(this.m_absolute[0])) {
                    ((Component)this.m_element).getAbsoluteTransformation(s_buffer);
                    assert (!s_buffer.isNaN());
                    s_buffer.getAsColumnMajorArray16(this.m_absolute);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInverseAbsoluteTransformationIfNecessary() {
        AffineMatrix4x4 affineMatrix4x4 = s_buffer;
        synchronized (affineMatrix4x4) {
            double[] dArray = this.m_inverseAbsolute;
            synchronized (this.m_inverseAbsolute) {
                if (Double.isNaN(this.m_inverseAbsolute[0])) {
                    ((Component)this.m_element).getInverseAbsoluteTransformation(s_buffer);
                    assert (!s_buffer.isNaN());
                    s_buffer.getAsColumnMajorArray16(this.m_inverseAbsolute);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[] getAbsoluteTransformation(double[] rv) {
        this.updateAbsoluteTransformationIfNecessary();
        double[] dArray = this.m_absolute;
        synchronized (this.m_absolute) {
            System.arraycopy(this.m_absolute, 0, rv, 0, rv.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[] getInverseAbsoluteTransformation(double[] rv) {
        this.updateInverseAbsoluteTransformationIfNecessary();
        double[] dArray = this.m_inverseAbsolute;
        synchronized (this.m_inverseAbsolute) {
            System.arraycopy(this.m_inverseAbsolute, 0, rv, 0, rv.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return rv;
        }
    }

    public DoubleBuffer accessAbsoluteTransformationAsBuffer() {
        this.updateAbsoluteTransformationIfNecessary();
        return this.m_absoluteBuffer;
    }

    public DoubleBuffer accessInverseAbsoluteTransformationAsBuffer() {
        this.updateInverseAbsoluteTransformationIfNecessary();
        return this.m_inverseAbsoluteBuffer;
    }

    public abstract void renderGhost(RenderContext var1, GhostAdapter var2);

    public abstract void renderOpaque(RenderContext var1);

    public abstract void setup(RenderContext var1);

    public abstract void pick(PickContext var1, PickParameters var2, ConformanceTestResults var3);
}

