/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import com.sun.opengl.util.j2d.TextureRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import edu.cmu.cs.dennisc.image.ImageUtilities;
import edu.cmu.cs.dennisc.lookingglass.opengl.TextureAdapter;
import edu.cmu.cs.dennisc.texture.CustomTexture;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTextureAdapter
extends TextureAdapter<CustomTexture> {
    private TextureRenderer m_textureRenderer = null;

    @Override
    protected boolean isDirty() {
        return ((CustomTexture)this.m_element).isAnimated() || super.isDirty();
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g = this.m_textureRenderer.createGraphics();
        return g;
    }

    @Override
    public void commitGraphics(Graphics2D g, int x, int y, int width, int height) {
        this.m_textureRenderer.markDirty(x, y, width, height);
    }

    @Override
    public Image getImage() {
        return this.m_textureRenderer.getImage();
    }

    @Override
    protected Texture newTexture(Texture currentTexture) {
        boolean isNewTextureRendererRequired = currentTexture != null ? (this.m_textureRenderer != null ? currentTexture.getWidth() != this.m_textureRenderer.getWidth() || currentTexture.getHeight() != this.m_textureRenderer.getHeight() : true) : true;
        if (isNewTextureRendererRequired) {
            if (this.m_textureRenderer != null) {
                this.m_textureRenderer.dispose();
            }
            this.m_textureRenderer = new TextureRenderer(((CustomTexture)this.m_element).getWidth(), ((CustomTexture)this.m_element).getHeight(), ((CustomTexture)this.m_element).isPotentiallyAlphaBlended());
        }
        Graphics2D g = this.m_textureRenderer.createGraphics();
        ((CustomTexture)this.m_element).paint(g, this.m_textureRenderer.getWidth(), this.m_textureRenderer.getHeight());
        g.dispose();
        this.m_textureRenderer.markDirty(0, 0, this.m_textureRenderer.getWidth(), this.m_textureRenderer.getHeight());
        if (((CustomTexture)this.m_element).isMipMappingDesired()) {
            Image image = this.m_textureRenderer.getImage();
            if (image instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)image;
                if (!((CustomTexture)this.m_element).isPotentiallyAlphaBlended()) {
                    try {
                        return TextureIO.newTexture((BufferedImage)bufferedImage, (boolean)true);
                    }
                    catch (AssertionError ae) {
                        System.err.println("WARNING: unable to directly generate mipmapped texture.");
                    }
                    catch (RuntimeException re) {
                        System.err.println("WARNING: unable to directly generate mipmapped texture.");
                    }
                }
                BufferedImage hackBI = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 7);
                Graphics2D hackG = hackBI.createGraphics();
                hackG.drawImage((Image)bufferedImage, 0, 0, ImageUtilities.accessImageObserver());
                hackG.dispose();
                bufferedImage = hackBI;
                return TextureIO.newTexture((BufferedImage)bufferedImage, (boolean)true);
            }
            return this.m_textureRenderer.getTexture();
        }
        return this.m_textureRenderer.getTexture();
    }
}

