/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.ElementAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeometryAdapter<E extends Geometry>
extends ElementAdapter<E> {
    private List<RenderContext> m_renderContexts = new LinkedList<RenderContext>();
    private boolean m_isGeometryChanged;

    public void addRenderContext(RenderContext rc) {
        this.m_renderContexts.add(rc);
    }

    public void removeRenderContext(RenderContext rc) {
        this.m_renderContexts.add(rc);
    }

    @Override
    public void handleReleased() {
        super.handleReleased();
        if (this.m_renderContexts.size() > 0) {
            RenderContext[] renderContexts = new RenderContext[this.m_renderContexts.size()];
            this.m_renderContexts.toArray(renderContexts);
            for (RenderContext rc : renderContexts) {
                rc.forgetGeometryAdapter(this, true);
            }
        }
    }

    protected boolean isGeometryChanged() {
        return this.m_isGeometryChanged;
    }

    protected void setIsGeometryChanged(boolean isGeometryChanged) {
        this.m_isGeometryChanged = isGeometryChanged;
    }

    public abstract boolean isAlphaBlended();

    protected boolean isDisplayListDesired() {
        return true;
    }

    protected boolean isDisplayListInNeedOfRefresh(RenderContext rc) {
        return this.isGeometryChanged();
    }

    protected abstract void renderGeometry(RenderContext var1);

    protected abstract void pickGeometry(PickContext var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(RenderContext rc) {
        if (this.isDisplayListDesired()) {
            Integer id = rc.getDisplayListID(this);
            if (id == null) {
                id = rc.generateDisplayListID(this);
                this.setIsGeometryChanged(true);
            }
            if (this.isDisplayListInNeedOfRefresh(rc) || !rc.gl.glIsList(id.intValue())) {
                rc.gl.glNewList(id.intValue(), 4865);
                try {
                    this.renderGeometry(rc);
                }
                finally {
                    rc.gl.glEndList();
                }
                this.setIsGeometryChanged(false);
            } else {
                rc.gl.glCallList(id.intValue());
            }
        } else {
            this.renderGeometry(rc);
        }
    }

    public final void pick(PickContext pc, boolean isSubElementRequired) {
        pc.gl.glBegin(1);
        pc.gl.glEnd();
        this.pickGeometry(pc, isSubElementRequired);
    }

    protected static Point3 getIntersectionInSourceFromPlaneInLocal(Point3 rv, Ray ray, AffineMatrix4x4 m, double px, double py, double pz, double nx, double ny, double nz) {
        Point3 position = new Point3(px, py, pz);
        Vector3 direction = new Vector3(nx, ny, nz);
        m.transform(position);
        m.transform(direction);
        Plane plane = new Plane(position, direction);
        if (plane.isNaN()) {
            rv.setNaN();
        } else {
            double t = plane.intersect(ray);
            ray.getPointAlong(rv, t);
        }
        return rv;
    }

    protected static Point3 getIntersectionInSourceFromPlaneInLocal(Point3 rv, Ray ray, AffineMatrix4x4 m, Point3 planePosition, Vector3 planeDirection) {
        return GeometryAdapter.getIntersectionInSourceFromPlaneInLocal(rv, ray, m, planePosition.x, planePosition.y, planePosition.x, planeDirection.x, planeDirection.y, planeDirection.z);
    }

    public abstract Point3 getIntersectionInSource(Point3 var1, Ray var2, AffineMatrix4x4 var3, int var4);
}

