/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.Graphics2D;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.ElementAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.GraphicAdapter;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Graphic;
import edu.cmu.cs.dennisc.scenegraph.Layer;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicAddedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicRemovedEvent;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerAdapter
extends ElementAdapter<Layer> {
    private List<GraphicAdapter<? extends Graphic>> activeGraphicAdapters = Collections.synchronizedList(new LinkedList());
    private List<GraphicAdapter<? extends Graphic>> forgetGraphicAdapters = Collections.synchronizedList(new LinkedList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGraphicAdded(GraphicAdapter<? extends Graphic> graphicAdapter) {
        List<GraphicAdapter<? extends Graphic>> list = this.activeGraphicAdapters;
        synchronized (list) {
            this.activeGraphicAdapters.add(graphicAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGraphicRemoved(GraphicAdapter<? extends Graphic> graphicAdapter) {
        List<GraphicAdapter<? extends Graphic>> list = this.forgetGraphicAdapters;
        synchronized (list) {
            this.forgetGraphicAdapters.add(graphicAdapter);
        }
    }

    public static void handleGraphicAdded(GraphicAddedEvent e) {
        LayerAdapter layerAdapter = AdapterFactory.getAdapterFor((Layer)e.getTypedSource());
        GraphicAdapter<? extends Graphic> graphicAdapter = AdapterFactory.getAdapterFor((Graphic)e.getChild());
        layerAdapter.handleGraphicAdded(graphicAdapter);
    }

    public static void handleGraphicRemoved(GraphicRemovedEvent e) {
        LayerAdapter layerAdapter = AdapterFactory.getAdapterFor((Layer)e.getTypedSource());
        GraphicAdapter<? extends Graphic> graphicAdapter = AdapterFactory.getAdapterFor((Graphic)e.getChild());
        layerAdapter.handleGraphicRemoved(graphicAdapter);
    }

    @Override
    public void initialize(Layer sgLayer) {
        super.initialize(sgLayer);
        for (Graphic sgGraphic : sgLayer.getGraphics()) {
            this.handleGraphicAdded(AdapterFactory.getAdapterFor(sgGraphic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render(Graphics2D g2, LookingGlass lookingGlass, Rectangle actualViewport, AbstractCamera camera) {
        List<GraphicAdapter<? extends Graphic>> list = this.forgetGraphicAdapters;
        synchronized (list) {
            for (GraphicAdapter<? extends Graphic> graphicAdapter : this.forgetGraphicAdapters) {
                graphicAdapter.forget(g2);
                List<GraphicAdapter<? extends Graphic>> list2 = this.activeGraphicAdapters;
                synchronized (list2) {
                    this.activeGraphicAdapters.remove(graphicAdapter);
                }
            }
            this.forgetGraphicAdapters.clear();
        }
        list = this.activeGraphicAdapters;
        synchronized (list) {
            for (GraphicAdapter<? extends Graphic> graphicAdapter : this.activeGraphicAdapters) {
                graphicAdapter.render(g2, lookingGlass, actualViewport, camera);
            }
        }
    }
}

