/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.awt.GraphicsUtilties;
import edu.cmu.cs.dennisc.lookingglass.opengl.LookingGlassFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.OnscreenLookingGlass;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLJPanel;
import javax.swing.JPanel;

class LightweightOnscreenLookingGlass
extends OnscreenLookingGlass
implements edu.cmu.cs.dennisc.lookingglass.LightweightOnscreenLookingGlass {
    private RenderPane glPanel = new RenderPane();

    LightweightOnscreenLookingGlass(LookingGlassFactory lookingGlassFactory) {
        super(lookingGlassFactory);
        this.glPanel.setFocusable(true);
    }

    public JPanel getJPanel() {
        return this.glPanel;
    }

    public Component getAWTComponent() {
        return this.getJPanel();
    }

    public Dimension getSize(Dimension rv) {
        return this.glPanel.getSize(rv);
    }

    public void repaint() {
        this.glPanel.repaint();
    }

    protected GLAutoDrawable getGLAutoDrawable() {
        return this.glPanel;
    }

    class RenderPane
    extends GLJPanel {
        private Throwable prevThrowable;

        public RenderPane() {
            super(LookingGlassFactory.createDesiredGLCapabilities(), LookingGlassFactory.getGLCapabilitiesChooser(), null);
            this.prevThrowable = null;
        }

        public void display() {
            if (LightweightOnscreenLookingGlass.this.isRenderingEnabled()) {
                super.display();
            }
        }

        private void paintRenderingDisabledMessage(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(Color.GRAY);
            g.fillRect(0, 0, size.width, size.height);
            String text = "rendering disabled for performance considerations";
            g.setColor(Color.BLACK);
            GraphicsUtilties.drawCenteredText(g, text, size);
            g.setColor(Color.YELLOW);
            g.translate(-1, -1);
            GraphicsUtilties.drawCenteredText(g, text, size);
            g.translate(1, 1);
            g.dispose();
        }

        public void paint(Graphics g) {
            if (LightweightOnscreenLookingGlass.this.isRenderingEnabled()) {
                super.paint(g);
            } else {
                this.paintRenderingDisabledMessage(g);
            }
        }

        protected void paintComponent(Graphics g) {
            if (LightweightOnscreenLookingGlass.this.isRenderingEnabled()) {
                if (LightweightOnscreenLookingGlass.this.getCameraCount() > 0) {
                    try {
                        super.paintComponent(g);
                        this.prevThrowable = null;
                    }
                    catch (Throwable throwable) {
                        g.setColor(Color.RED);
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g.setColor(Color.BLACK);
                        GraphicsUtilties.drawCenteredText(g, "error in attempting to render scene", this.getSize());
                        if (this.prevThrowable == null) {
                            this.prevThrowable = throwable;
                            throwable.printStackTrace();
                        }
                    }
                } else {
                    g.setColor(Color.DARK_GRAY);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
        }
    }
}

