/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.opengl.LookingGlassFactory;
import java.awt.Dimension;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLPbuffer;

class OffscreenLookingGlass
extends AbstractLookingGlass
implements edu.cmu.cs.dennisc.lookingglass.OffscreenLookingGlass {
    private GLPbuffer glPbuffer;
    private AbstractLookingGlass lookingGlassToShareContextWith;

    OffscreenLookingGlass(LookingGlassFactory lookingGlassFactory, AbstractLookingGlass lookingGlassToShareContextWith) {
        super(lookingGlassFactory);
        this.lookingGlassToShareContextWith = lookingGlassToShareContextWith;
    }

    public Dimension getSize(Dimension rv) {
        if (this.glPbuffer != null) {
            rv.setSize(this.glPbuffer.getWidth(), this.glPbuffer.getHeight());
        } else {
            rv.setSize(0, 0);
        }
        return rv;
    }

    public void setSize(int width, int height) {
        assert (width > 0);
        assert (height > 0);
        if (this.glPbuffer != null) {
            if (width != this.glPbuffer.getWidth() || height != this.glPbuffer.getHeight()) {
                this.glPbuffer.setSize(width, height);
            }
        } else {
            GLContext share = this.lookingGlassToShareContextWith != null ? this.lookingGlassToShareContextWith.getGLAutoDrawable().getContext() : null;
            this.glPbuffer = LookingGlassFactory.getSingleton().createGLPbuffer(width, height, share);
        }
    }

    public void clearAndRenderOffscreen() {
        this.getGLAutoDrawable().display();
    }

    protected void actuallyRelease() {
        super.actuallyRelease();
        if (this.glPbuffer != null) {
            this.glPbuffer.destroy();
        }
    }

    protected GLAutoDrawable getGLAutoDrawable() {
        assert (this.glPbuffer != null);
        return this.glPbuffer;
    }

    protected void repaintIfAppropriate() {
    }
}

